<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\SmsLog;
use App\EmailSmsType;
use App\Customer;
class SMSLogController extends Controller
{
    //
    protected $sms_log;

    public function __construct()
    {

        $this->sms_log = new SmsLog();
    }
    public function index(){

        $email_sms_type=  EmailSmsType::all();
     $customer_mobile= Customer::where('mobile_number','!=',null)->get();
        $sms_log= SmsLog::paginate(25);
        return view('Setting.smslog.index',compact('sms_log','email_sms_type','customer_mobile'));
    }
    public function resendSms(Request $request){

        $sms_log=  SmsLog::where('id',$request->value)->first();
        $response=     SmsController::sendSMS($sms_log->receiver_number,$sms_log->content);
       
         
           
           if (strpos($response, 'Your Message is sent') !== false){
             $sms_log->status = 1;
             $sms_log->response = $response;
         
             $sms_log->save();
             return redirect()
             ->back()
             ->with([
                 'message' => 'SMS Send Successfully!',
                 'alert-type' => 'success'
             ]);
           }
           else{
             $sms_log->status = 0;
             $sms_log->response = $response;
         
             $sms_log->save();
             return redirect()
             ->back()
             ->with([
                 'message' => 'Unable to send sms!',
                 'alert-type' => 'success'
             ]);
           }
          
           return redirect()
           ->back()
           ->with([
               'message' => 'SomeThing went wrong!',
               'alert-type' => 'error'
           ]);

     }
    
     public function updateTable(Request $request)
     {  
         $filters = array();
         if ($request->title != 0)
             $filters['title'] = $request->title;
         if ($request->email != 0)
             $filters['email'] = $request->email;
         if ($request->status != 0)
             $filters['status'] = $request->status;
        
        $data = $this->sms_log->updateTable($filters);
        return view('Setting.smslog.update-table', $data);
     }

}
