<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use App\SchedulePlan;
use App\CustomerStatement;
use App\PaymentHeadPriority;
use App\Receipt;
use DB;

class SchedulePlanController extends Controller
{
    protected $plan;

    public function __construct() {
        $this->plan = new SchedulePlan();
    }

    public function getSchedulePlan() {
         $data =array();

        $data['plan'] =  SchedulePlan::first();

        $priorities = PaymentHeadPriority::all();

        foreach ($priorities as $key => $value) 
        {
            if($value->payment_head == Receipt::down_payment)
            {
             $data['down_payment_priority'] = $value->priority;
            }

            if($value->payment_head == Receipt::possession_fee)
            {
               $data['possession_priority'] = $value->priority;
            }

            if($value->payment_head == Receipt::installment)
            {
                 $data['installment_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::allotment)
            {
                $data['allotment_priority'] = $value->priority;
            }
            if($value->payment_head ==Receipt::confirmation)
             {
                $data['confirmation_priority'] = $value->priority;
             }
            if($value->payment_head == Receipt::booking)
            {
                 $data['booking_priority'] = $value->priority;
            }
           
            if($value->payment_head == Receipt::file_processing)
            {
                 $data['file_processing_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::registration)
            {
                  $data['registration_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::ballon)
            {
                  $data['ballon_priority'] = $value->priority; 
            }
            if($value->payment_head == Receipt::balloting)
            {
                  $data['bulleting_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::semi_annual_installment)
            {
                  $data['semi_annual_installment_priority'] = $value->priority;
            }

 }


        return view('Setting/schedule.index', $data );
    }



     public function getVoucherValidDate() 
     {
         $data =array();

        $data['plan'] =  SchedulePlan::first();

        return view('Setting/schedule.voucher-valid-date', $data );
    }



    //show the edit Schedule form
    public function editSchedulePlanForm($id) 
    {
        // ballon
        // balloting
        // semi_installment
        $data =array();

        $data['plan'] = SchedulePlan::where('id', $id)->first();
         
 
        $priorities = PaymentHeadPriority::all();

        foreach ($priorities as $key => $value) 
        {
            if($value->payment_head == Receipt::down_payment)
            {
             $data['down_payment_priority'] = $value->priority;
            }

            if($value->payment_head == Receipt::possession_fee)
            {
               $data['possession_priority'] = $value->priority;
            }

            if($value->payment_head == Receipt::installment)
            {
                 $data['installment_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::allotment)
            {
                $data['allotment_priority'] = $value->priority;
            }
            if($value->payment_head ==Receipt::confirmation)
             {
                $data['confirmation_priority'] = $value->priority;
             }
            if($value->payment_head == Receipt::booking)
            {
                 $data['booking_priority'] = $value->priority;
            }
            // if($value->payment_head == Receipt::development)
            // {
            //       $data['development_priority'] = $value->priority;
            // }
            if($value->payment_head == Receipt::file_processing)
            {
                 $data['file_processing_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::registration)
            {
                  $data['registration_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::ballon)
            {
                  $data['ballon_priority'] = $value->priority;
               
            }
            if($value->payment_head == Receipt::balloting)
            {
                  $data['bulleting_priority'] = $value->priority;
            }
            if($value->payment_head == Receipt::semi_annual_installment)
            {
                  $data['semi_annual_installment_priority'] = $value->priority;
            }
           

 }


        return view('Setting/schedule.edit-plan', $data);
    }



     public function editVoucherValidDate($id) 
    {
        $data =array();

        $data['plan'] = SchedulePlan::where('id', $id)->first();

        return view('Setting/schedule.edit-voucher-valid-date', $data);
    }


    public function updatePaymentHead(Request $request)
    {
        $payment_head_id = $request->payment_head_id;
        $possession_date = $request->possession_date;
        if (!empty($possession_date) && !empty($payment_head_id)) 
        {
           
            $update_possession_date = CustomerStatement::where('id' , $payment_head_id)->update([
            'due_date' => $possession_date ,
            ]);
            return $update_possession_date;   
        }
        else
        {
            return 'empty';
        }

    }

    //update the Schedule plan record
    public function updateSchedulePlan(Request $request) {

       
                // $validator = Validator::make($request->all(), [
                //     'possession'=>'required|numeric',
                //     'possession_date' => 'required',
                //     'down_payment'=>'required|numeric|min:0',
                //     'monthly_installment'=>'required|numeric|min:0',
                //     'total_months'=>'required|numeric|min:12',
                //     'fine'=>'required',
                //     'down_payment_priority' => 'required|numeric|min:0',
                //     'installment_priority' => 'required|numeric|min:0',
                //     'possession_priority' => 'required|numeric|min:0',
                //     'possession'=>'required|numeric|min:0',
                //     'allotment_priority' => 'required|numeric|min:0',
                //     'allotment'=>'required|numeric|min:0',
                //     'confirmation_priority' => 'required|numeric|min:0',
                //     'confirmation'=>'required|numeric|min:0',
                //     'booking_priority' => 'required|numeric|min:0',
                //     'booking'=>'required|numeric|min:0',
                //     'development_priority' => 'required|numeric|min:0',
                //     'development'=>'required|numeric|min:0',
                //     'file_processing_priority' => 'required|numeric|min:0',
                //     'file_processing'=>'required|numeric|min:0',
                //     'registration_priority' => 'required|numeric|min:0',
                //     'registration'=>'required|numeric|min:0',

                //     "ballon_priority" => 'required|numeric|min:0',
                //     "ballon" => 'required|numeric|min:0|max:100',
                //     "bulleting_priority" => 'required|numeric|min:0',
                //     "bulleting" => 'required|numeric|min:0|max:100',
                //     "semi_annual_priority" => 'required|numeric|min:0',
                //     "semi_annual" => 'required|numeric|min:0|max:100',
                // ]);
                $this->validate($request,[
                    'possession'=>'required|numeric',
                    'possession_date' => 'required',
                    'down_payment'=>'required|numeric|min:0',
                    'monthly_installment'=>'required|numeric|min:0',
                    'total_months'=>'required|numeric|min:12',
                    'fine'=>'required',
                    'down_payment_priority' => 'required|numeric|min:0',
                    'installment_priority' => 'required|numeric|min:0',
                    'possession_priority' => 'required|numeric|min:0',
                    'possession'=>'required|numeric|min:0',
                    'allotment_priority' => 'required|numeric|min:0',
                    'allotment'=>'required|numeric|min:0',
                    'confirmation_priority' => 'required|numeric|min:0',
                    'confirmation'=>'required|numeric|min:0',
                    'booking_priority' => 'required|numeric|min:0',
                    'booking'=>'required|numeric|min:0',
                    // 'development_priority' => 'required|numeric|min:0',
                    // 'development'=>'required|numeric|min:0',
                    'file_processing_priority' => 'required|numeric|min:0',
                    'file_processing'=>'required|numeric|min:0',
                    'registration_priority' => 'required|numeric|min:0',
                    'registration'=>'required|numeric|min:0',

                    "ballon_priority" => 'required|numeric|min:0',
                    "ballon" => 'required|numeric|min:0|max:100',
                    "bulleting_priority" => 'required|numeric|min:0',
                    "bulleting" => 'required|numeric|min:0|max:100',
                    "semi_annual_priority" => 'required|numeric|min:0',
                    "semi_annual" => 'required|numeric|min:0|max:100',
                    
                 ]);
        $ballon = $request->ballon;
        $balloting = $request->bulleting;
        $semi_annual = $request->semi_annual;
        $downpayment = $request->down_payment;
        $monthly_installment = $request->monthly_installment;
        $possession = $request->possession;
        $allotment = $request->allotment;
        $confirmation = $request->confirmation;
        $booking = $request->booking;
        $file_processing = $request->file_processing; 
        $registration= $request->registration;

      
                // if ($validator->fails()) 
                // {
                   
                //     return redirect('/payment-schedule/edit/'.$request->id)
                //     ->withErrors($validator)
                //     ->withInput()
                //     ->with([
                //     'message' => 'Invalid Inputs!',
                //     'alert-type' => 'error',
                //     ]);
                // }
                if($request->semi_annual_priority == 0){
 
                    $semi_annual =0;
                    
            
                }
                if($request->ballon_priority == 0){
                    $ballon = 0;
                    
            
                }
                if($request->bulleting_priority == 0){
                    
                    $balloting = 0;
                     
            
                }
                if($request->registration_priority == 0){
                     
                    $registration= 0;
            
                }
                if($request->file_processing_priority == 0){
                    
                    $file_processing = 0; 
                   
            
                }
        if ($request->booking_priority == 0) {
            
            $booking = 0;
           
        }
        if ($request->confirmation_priority == 0) {
            
            $confirmation = 0;
           
        }
        if ($request->allotment_priority == 0) {
            
            $allotment = 0;
            
        }
        if ($request->installment_priority == 0) {
            
            $monthly_installment = 0;
            
        }
        if ($request->possession_priority == 0) {
           
            $possession =0;
            
        }
        if ($request->down_payment_priority == 0) {
            
            $downpayment = 0;
           
        }
       
        $total_per = $ballon +
        $balloting +
        $semi_annual +
        $downpayment +
        $monthly_installment +
        $possession +
        $allotment +
        $confirmation+
        $booking +
        $file_processing +
        $registration;
            // $total_per = $request->ballon+ $request->bulleting+ $request->semi_annual+ $request->down_payment + $request->monthly_installment  +  $request->possession + $request->allotment + $request->confirmation + $request->booking  + $request->file_processing + $request->registration;


            if ($total_per > 100) 
            {
                return redirect('/payment-schedule/edit/'.$request->id)
                ->withInput()
                ->with([
                'message' => 'Your overall percentage is '.$total_per.' that is greater than 100.',
                'alert-type' => 'error',
                ]);
            } else if ($total_per < 100) {
                return redirect('/payment-schedule/edit/'.$request->id)
                ->withInput()
                ->with([
                'message' => 'Your overall percentage is '.$total_per.' that is less than 100.',
                'alert-type' => 'error',
                ]);
            }

        DB::beginTransaction();

         try {

            CustomerStatement::where('payment_head' , CustomerStatement::possession)->update([
            'due_date' => $request->possession_date,
            ]);

           
            SchedulePlan::where('id',$request->id)->update([
            'total_months' => $request->total_months,
            'fine' => $request->fine,
            'possession_date' => $request->possession_date,
            'down_payment' => $downpayment,
            'monthly_installment' =>$monthly_installment,
            'annual_installment' => $request->annual_installment,
            'possession' => $possession,
            'allotment' => $allotment ,
            'confirmation' =>  $confirmation,
            'booking' => $booking,
            // 'development' => $request->development,
            'file_processing' => $file_processing,
            'registration' => $registration,
          'ballon'  =>  $ballon,
           'bulleting' =>  $balloting,
           'semi_installment' =>  $semi_annual
             ]);
             
             PaymentHeadPriority::where('payment_head', '!=', Receipt::development)->truncate();

        PaymentHeadPriority::create(['payment_head' => Receipt::down_payment, 'priority' => $request->down_payment_priority]);

        PaymentHeadPriority::create(['payment_head' => Receipt::possession_fee, 'priority' => $request->possession_priority]);

        PaymentHeadPriority::create(['payment_head' => Receipt::installment, 'priority' => $request->installment_priority]);


        PaymentHeadPriority::create(['payment_head' => Receipt::allotment, 'priority' => $request->allotment_priority]);


        PaymentHeadPriority::create(['payment_head' => Receipt::confirmation, 'priority' => $request->confirmation_priority]);


        PaymentHeadPriority::create(['payment_head' => Receipt::booking, 'priority' => $request->booking_priority]);


        // PaymentHeadPriority::create(['payment_head' => Receipt::development, 'priority' => $request->development_priority]);

       
        PaymentHeadPriority::create(['payment_head' => Receipt::file_processing, 'priority' => $request->file_processing_priority]);

        PaymentHeadPriority::create(['payment_head' => Receipt::registration, 'priority' => $request->registration_priority]);

        
        
        PaymentHeadPriority::create(['payment_head' => Receipt::ballon, 'priority' => $request->ballon_priority]);


        PaymentHeadPriority::create(['payment_head' => Receipt::balloting, 'priority' => $request->bulleting_priority]);

        PaymentHeadPriority::create(['payment_head' => Receipt::semi_annual_installment, 'priority' => $request->semi_annual_priority]);


        DB::commit();


        return redirect()
        ->route('schedule.all')
        ->with([
        'message' => 'Installment Plan updated successfully!',
        'alert-type' => 'info'
        ]);


        }
        catch (\Exception $e) 
        {//dd($e);
        DB::rollback();
        return false;
        }

    }



    //update the Schedule plan record
    public function updateVoucherValidDate(Request $request) {

                $validator = Validator::make($request->all(), [
                    'voucher_valid_after' => 'required',
                ]);

                if ($validator->fails()) 
                {
                    return redirect('/voucher-valid-date/edit/'.$request->id)
                    ->withErrors($validator)
                    ->withInput()
                    ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                    ]);
                }

           
        DB::beginTransaction();

         try {
           
            SchedulePlan::where('id',$request->id)->update([
                'voucher_valid_after' => $request->voucher_valid_after,
             ]);

            DB::commit();

            return redirect()
            ->route('voucher.valid.date')
            ->with([
                'message' => 'Voucher Valid Date updated successfully!',
                'alert-type' => 'info'
            ]);

        }

        catch (\Exception $e) 
        {
            DB::rollback();
            return false;
        }
    }


}
