<?php

namespace App\Http\Controllers;

use App\Mail\TestSmtpSetting;
use Illuminate\Http\Request;

use App\SmtpSetting;

class SmtpSettingController extends Controller
{
    //
    public function index()
    {

        $smtps = SmtpSetting::all();
        return view('stmp-setting.index', compact('smtps'));
    }
    public function add()
    {
        return view('stmp-setting.add');
    }
    public function store(Request $request)
    {
 

        $this->validate($request, [
            "host" =>['required', 'max:255'],
            "username" => ['required', 'string', 'max:255'],
            "password" =>['required', 'max:255'],
            "name"=>['required', 'string', 'max:255'],
            "fromusername"=> ['required', 'string', 'max:255'],
            "fromemail"=> ['required', 'string', 'email', 'max:255'],
        ]);
        $smtp =  new  SmtpSetting;
        $smtp->smtp_host = $request->host;
        $smtp->smtp_port = '587';
        $smtp->smtp_username = $request->username;
        $smtp->smtp_password = $request->password;

        $smtp->name = $request->name;
        $smtp->smtp_encryption = 'tls';
        $smtp->from_name = $request->fromusername;
        $smtp->from_email = $request->fromemail;
        if ($request->status == 'on') {
            $smtp->status = 1;
        }
        else{
            $smtp->status = 0;
        }
        $smtp->save();
        return redirect()
            ->route('stmp.index')
            ->with([
                'message' => 'Setting Added Successfully!',
                'alert-type' => 'success'
            ]);
    }
    public function testSmtpSetting($id)
    {
        $smtp =  SmtpSetting::where('id', $id)->first();
        return view('stmp-setting.test-setting', compact('smtp'));
    }
    public function sendTestSmtpSettingOLD(Request $request)
    {
        $this->validate($request, [
            "id" => "required",
            "rece_email" => ['required', 'string', 'email'],

        ]);





        $data = [
            'username' => '1',
            'email' => '2',
        ];


        $smtp = SmtpSetting::where('id', $request->id)->first();
        $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
            ->setUsername($smtp->smtp_username)
            ->setPassword($smtp->smtp_password);
        $mailer = new \Swift_Mailer($transport);
        $email = (new TestSmtpSetting($data))
            ->subject('Test SMTP Setting')
            ->from('sender@example.com', 'Test')
            ->to($request->rece_email)
            ->view('emails.testsmtp-setting');

        // Render the email message using Laravel's template engine
        $message = $email->render();

        $swiftMessage = (new \Swift_Message())
            ->setSubject('Test SMTP Setting')
            ->setFrom('sender@example.com', 'Test')
            ->setTo($request->rece_email)
            ->setBody($message, 'text/html');

        // Send the email using the SwiftMailer instance
        $m = $mailer->send($swiftMessage);
        dd($m);
        // $email = (new \Swift_Message('Test SMTP Setting'))
        //         ->setFrom(['sender@example.com' => 'Test'])
        //         ->setTo([$request->rece_email])
        //         ->setBody('This is a dummy email');


        // $m = $mailer->send((new TestSmtpSetting($data))->subject($email->getSubject())->from('tes@g.com')->to('dumy@t.com'));

        dd('t');
        $id =     $request->id;
        $email = new TestSmtpSetting($id);
        dd($email);









        $smtp =  SmtpSetting::where('id', $request->id)->first();
        $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
            ->setUsername($smtp->smtp_username)
            ->setPassword($smtp->smtp_password);

        $mailer = new \Swift_Mailer($transport);

        $email = (new \Swift_Message('Test SMTP Setting'))
            ->setFrom(['sender@example.com' => 'Test'])
            ->setTo([$request->rece_email])
            ->setBody('This is dumy email ');

        $m = $mailer->send($email);
        dd($m);
        return view('stmp-setting.test-setting', compact('smtp'));
    }
    public function sendTestSmtpSetting(Request $request)
    {
        $this->validate($request, [
            "id" => "required",
            "rece_email" => ['required', 'string', 'email'],

        ]);
        $smtp = SmtpSetting::where('id', $request->id)->first();
        $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
            ->setUsername($smtp->smtp_username)
            ->setPassword($smtp->smtp_password);
        $mailer = new \Swift_Mailer($transport);
        $email = (new TestSmtpSetting( $smtp->name))
            ->subject('Test SMTP Setting')
            ->from($smtp->from_email, $smtp->from_name)
            ->to($request->rece_email)
            ->view('emails.testsmtp-setting');

        // Render the email message using Laravel's template engine
        $message = $email->render();

        $swiftMessage = (new \Swift_Message())
            ->setSubject('Test SMTP Setting')
            ->setFrom($smtp->from_email, $smtp->from_name)
            ->setTo($request->rece_email)
            ->setBody($message, 'text/html');

        // Send the email using the SwiftMailer instance
        $response = $mailer->send($swiftMessage);
       if($response){
        return redirect()
        ->back()
        ->with([
            'message' => 'Email Send Successfully!',
            'alert-type' => 'success'
        ]);
       }
       else{
        return redirect()
        ->back()
        ->with([
            'message' => 'SomeThing Went Wrong!',
            'alert-type' => 'error'
        ]);
       }
         
    }

    public function edit($id){
        $smtp =  SmtpSetting::where('id', $id)->first();
        return view('stmp-setting.edit', compact('smtp'));
    }
    public function update(Request $request){
        $this->validate($request, [
            "host" =>['required', 'max:255'],
            "username" => ['required', 'string', 'max:255'],
            "password" =>['required', 'max:255'],
            "name"=>['required', 'string', 'max:255'],
            "fromusername"=> ['required', 'string', 'max:255'],
            "fromemail"=> ['required', 'string', 'email', 'max:255'],
        ]);
        $smtp =  SmtpSetting::where('id',$request->id)->first();
        $smtp->smtp_host = $request->host;
        $smtp->smtp_port = '2525';
        $smtp->smtp_username = $request->username;
        $smtp->smtp_password = $request->password;

        $smtp->name = $request->name;
        $smtp->smtp_encryption = 'tls';
        $smtp->from_name = $request->fromusername;
        $smtp->from_email = $request->fromemail;
        if ($request->status == 'on') {
            $smtp->status = 1;
        }else{
            $smtp->status = 0;
        }
        $smtp->save();
        return redirect()
            ->route('stmp.index')
            ->with([
                'message' => 'Setting Updated Successfully!',
                'alert-type' => 'success'
            ]);
    }
    }

