<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MaterialIssueRequest;
use App\ItemRelease;
use App\Department;   
use App\PurchaseOrder;

class StoreKeeperController extends Controller
{
    

     public function __construct()
    {
               
    }

    function index()
    {

        $total_pending_mir = MaterialIssueRequest::where('status' , 'pending' )->get();
        $total_release_mir = MaterialIssueRequest::where('status' , 'release' )->count();

        $total_department_release = ItemRelease::where([['purchase_request_id' , 0] , ['releaser_name' , '!=' , null ] , ['releasing_date' , '!=' , null] ] )->count();
        $total_department_return = ItemRelease::where([['purchase_request_id' , 0] , ['returning_name' , '!=' , null ] , ['return_date' , '!=' , null] ] )->count();

        $item_releasings = ItemRelease::with([ 'department' , 'releasingItems'])
        ->whereNotNull('releasing_date')
        ->whereNotNull('releaser_name')
        ->orderBy('id', 'DESC')
        ->get()->take(5);
        $item_releasings = json_decode(json_encode($item_releasings )) ;

        $item_returings = ItemRelease::with([ 'department' , 'releasingItems'])
        ->whereNotNull('returning_name')
        ->whereNotNull('return_date')
        ->orderBy('id', 'DESC')
        ->get()->take(5);
        $item_returings = json_decode(json_encode($item_returings )) ;

        $departments = Department::orderBy('department_name')->get();
        $mirs = MaterialIssueRequest::where('status' , 'pending')->get();

        $sent_purchase_orders = PurchaseOrder::with(['vendor'])->where('status' , 1)->count();
        $receive_purchase_orders = PurchaseOrder::with(['vendor'])->where('status' , 2)->count();
        $partial_purchase_orders = PurchaseOrder::with(['vendor'])->where('status' , 3)->count();

        return view('procurement/store-keeper.dashboard' ,compact('total_pending_mir'  , 'total_release_mir' , 'total_department_release','total_department_return' , 'item_releasings' , 'item_returings' , 'departments' , 'mirs' , 'sent_purchase_orders' , 'receive_purchase_orders' , 'partial_purchase_orders')  );
    }

    public function purchaseOrder()
    {
        $sent_purchase_orders = PurchaseOrder::with(['vendor'])->where('status' , 1)->get();
        $receive_purchase_orders = PurchaseOrder::with(['vendor'])->where('status' , 2)->get();
        $partial_purchase_orders = PurchaseOrder::with(['vendor'])->where('status' , 3)->get();

        return view('procurement/store-keeper.purchase-order' ,compact('sent_purchase_orders' , 'receive_purchase_orders' , 'partial_purchase_orders'));
    }


}
