<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Task;
use App\Item;
use Illuminate\Support\Facades\Validator;
use DB;
use App\billOfQuantity;
use App\Link;

class TaskController extends Controller
{

    public function __construct()
    {
               
    }

    public function index()
    {
         $task = Task::where('parent', '=', 0)->get();

         return view('procurement.work-order.index' , compact('task'));
    }

       public function viewWorkOrder()
    {
        return view('procurement.work-order.dashboard');
    }

    public function create()
    {

    $items = Item::orderBy('id', 'DESC')->get(['id','item_name','unit']);

    $task = Task::where('parent', '=', 0)->get();

      return view('procurement.work-order.create' , compact('task' , 'items'));
    }


     public function store(Request $request)
     {

        if ($request->order_status == 'true') 
        {
            $validationArray = [
                'name' => 'required|unique:tasks,text',
                'start_date' => 'required',
                'duration' => 'required',
                'progress' => 'required|integer|min:0|max:100',
                'priorty' => 'required',
                'task_type' => 'required',
                'assign_to' => 'required',
                'created_by' => 'required',
                'parent' => 'required|integer|min:0'
            ];
        }
        else if ($request->order_status == 'false') 
        {
            $validationArray = [
                'name' => 'required|unique:tasks,text',
                'parent' => 'required|integer|min:0',
            ];
        }

        $validator = Validator::make($request->all(), $validationArray );

        if ($validator->fails()) 
        {
            return json_encode(array('response' => 'error' , 'errors' => $validator->messages()));
             exit();
        }

         if ($request->order_status == 'true' && $request->parent == 0) 
        {
               return json_encode(array('response' => 'custom_error' , 'errors' => 'Please Select Parent Task.'));
               exit();
        }


          if(count(array_unique( array_column($request->items, 'item_id') )) < count($request->items))
        {
            echo json_encode(array('response' => 'custom_error' , 'errors' => 'One of your item is Repeated. Please re-check and select again.'));
            exit();
        }

        $duration = $request->duration;
        $start_date = (!empty($request->start_date)) ? $request->start_date : date('Y-m-d');
    

        if ($request->order_status == 'true' && $request->validate_start_date == 'false') 
            {
                //...................validate start date........................//

              $get_end_date = Task::where('node_name' , 'leaf')->latest('task_end_date')->first();

              if ($get_end_date  == true &&  ($start_date <= date('Y-m-d' , strtotime($get_end_date->task_end_date))) ) 
              {
                    $next_day = date('d-F-Y', strtotime($get_end_date->task_end_date . ' + 1days'));
                    return json_encode(array('response' => 'start_date_alert' , 'errors' => '<center>Another task '.$get_end_date->text.' end date is '.date('d-F-Y' , strtotime($get_end_date->task_end_date)).'. Start this task from '.$next_day.'<br> <b>OR</b> <br> Are you agree to continue with this date '.date('d-F-Y' , strtotime($start_date)).'? </center>'));
                    exit();  
              }
          }


       DB::beginTransaction();

       try {

        $task = new Task();
        
        if ($request->progress < 10) 
        {
            $progress = '0.0'.$request->progress;
        }
        else if($request->progress > 9 && $request->progress < 100)
        {
            $progress = '0.'.$request->progress;
        }
        else
        {
            $progress = 1;
        }
    
        $task->text = $request->name;
        $task->start_date =  $start_date;

        if (!empty($duration)) 
        {
            $end_duration = $duration - 1;

            if ($end_duration > 0) 
            {
               $end_duration = $end_duration;
            }
            else
            {
                $end_duration = 0;
            }

            $end_date = date('Y-m-d', strtotime($start_date . ' + '.$end_duration.' days'));
            $task->task_end_date = $end_date;
        }

        $task->duration = $duration;
        $task->progress =  $progress;
        $task->parent = $request->parent;
        $task->description = $request->description;
        $task->task_priority = $request->priorty;
        $task->assign_to = $request->assign_to;
        $task->created_by = $request->created_by;
        $task->task_type = $request->task_type;

        if ($request->order_status == 'true') 
        {
          $task->node_name = 'leaf';
        }

        $task->save();

        //.......................Create Task Links....................// 



        if ($request->parent > 0) 
        {
            Link::create([
                'type' => 1,
                'source' =>$request->parent,
                'target' => $task->id,
            ]);
        }

        //.......................Create Task Links END................// 

        if ($request->order_status == 'true') 
        {

        //................Add bill Of quantity .......................//

        if( $task->id > 0 && !empty($request->items))
        {
        for ($item = 0; $item < sizeof( $request->items); $item++) 
        {
            if (empty($request->items[$item]['item_id']) || $request->items[$item]['item_id'] == 0)
            {
                DB::rollback();
                return json_encode(array('response' => 'custom_error' , 'errors' => 'Please Select item(s).'));
                exit();
            }

            if (empty($request->items[$item]['quantity']) || $request->items[$item]['quantity'] == 0)
            {
                DB::rollback();
                  return json_encode(array('response' => 'custom_error' , 'errors' => 'Please add valid item(s) quantity.'));
                exit();
            }

            if (empty($request->items[$item]['price']) || $request->items[$item]['price'] == 0)
            {
                DB::rollback();
                 return json_encode(array('response' => 'custom_error' , 'errors' => 'Please add valid item(s) rate per unit.'));
                exit();
            }

              $current_item = Item::find($request->items[$item]['item_id']);

            if(($current_item->quantity + $request->items[$item]['quantity']) > $current_item->maxqty)
            {
               $validOrderQty = $current_item->maxqty - $current_item->quantity;

               if($validOrderQty <= 0 )
               {
                 $validOrderQty = 0;
               }
                  DB::rollback();
                 return json_encode(array('response' => 'custom_error' , 'errors' => 'Item <b>'.$current_item->item_name.' </b> has max order Quantity is '.$current_item->maxqty.'. you  have already '.$current_item->quantity.' . you can only order now '. ( $validOrderQty ).'.'));
               
                 exit();
            }


             billOfQuantity::create([
                'task_id' => $task->id,
                'item_id' => $request->items[$item]['item_id'],
                'quantity' => $request->items[$item]['quantity'],
                'rate_per_unit' => $request->items[$item]['price'],
                'total_cost' => $request->items[$item]['quantity'] * $request->items[$item]['price'],
              ]);
        }

            $total_task_cost=billOfQuantity::where('task_id' , $task->id)->sum('total_cost');
          
            Task::where('id' , $task->id)->update([
             'total_cost' =>  $total_task_cost,
            ]);
        }

        //...............Update Parent Nodes...........................//

         $this->updateParentNodes($request->parent);

        }
 
          DB::commit();

          return response()->json([
            "response"=> "inserted",
            'message' => 'A New Work Order Added Successfully!',
            "tid" => $task->id
          ]);
      
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
dd($e);
      }
    }
 
     public function updateParentNodes($parent = null)
     {
            //$duration =  Task::where('parent' , $parent)->sum('duration');

            $total_cost =  Task::where('parent' , $parent)->sum('total_cost');
            $get_start_date = Task::where('parent' , $parent)->oldest('start_date')->first();
            $get_end_date = Task::where('parent',$parent)->latest('task_end_date')->first();
            $parent_task_progress = 0;
            $dura = strtotime($get_start_date) - strtotime($get_end_date);

            $duration =  round($dura / (60 * 60 * 24));
            $data = [
            'duration' => $duration,
            'progress' => $parent_task_progress,
            'total_cost' => $total_cost,
            ];

           if ($get_start_date == true)
           {
               $start_date = $get_start_date->start_date;
           }

            if ($get_end_date == true)
           {
               $end_date = $get_end_date->task_end_date;
           }
        
        $tasks = Task::where('parent' , $parent)->get();

        if ($tasks->count() > 0) 
        {
           
            $total = $tasks->count() * 100;
            $total_progress = 0;

            foreach ($tasks as $key => $task)
            {
                $total_progress += $task->progress;
            }

           $total_progress * 100;
           $parent_task_progress = ($total_progress/$total) * 100;
           $data['start_date'] = $start_date;
           $data['task_end_date'] = $end_date;
         }

         $task =  tap(Task::where('id' , $parent))->update($data)->first();

         $If_has_parent = Task::where('id' , $task->parent)->get();

         if ($If_has_parent->count() > 0 )
         {
              $this->updateParentNodes($task->parent);
         }
      
         return;
     }

     public function edit($id = null)
     {
        $items = Item::orderBy('id', 'DESC')->get(['id','item_name','unit']);

        $tasks = Task::where('parent', '=', 0)->get();

        $task = Task::where('id', '=', $id)->first();

        $bill_of_quantities = billOfQuantity::where('task_id' , $id)->get();

        return view('procurement.work-order.edit' , compact('tasks' , 'items' , 'task' , 'bill_of_quantities'));
     }

     public function update(Request $request)
     {
        $id = $request->id;

         if ($request->order_status == 'true') 
        {
            $validationArray = [
                'name' => 'required|unique:tasks,text,'.$id,
                'start_date' => 'required',
                'duration' => 'required',
                'progress' => 'required|integer|min:0|max:100',
                'priorty' => 'required',
                'task_type' => 'required',
                'assign_to' => 'required',
                'created_by' => 'required',
                'id' => 'required',
                'parent' => 'required|integer|min:0'
            ];
        }
       

        $validator = Validator::make($request->all(), $validationArray );

        if ($validator->fails()) 
        {
            return json_encode(array('response' => 'error' , 'errors' => $validator->messages()));
             exit();
        }

         if ($request->order_status == 'true' && $request->parent == 0) 
        {
               return json_encode(array('response' => 'custom_error' , 'errors' => 'Please Select Parent Task.'));
               exit();
        }

          if(count(array_unique( array_column($request->items, 'item_id') )) < count($request->items))
        {
            echo json_encode(array('response' => 'custom_error' , 'errors' => 'One of your item is Repeated. Please re-check and select again.'));
            exit();
        }

         $duration = $request->duration;
         $start_date = (!empty($request->start_date)) ? $request->start_date : date('Y-m-d');
       


       DB::beginTransaction();

       try {

         $task = Task::find($id);
        $task_parent =  $task->parent;
    
         if ($request->progress < 10) 
        {
            $progress = '0.0'.$request->progress;
        }
        else if($request->progress > 9 && $request->progress < 100)
        {
            $progress = '0.'.$request->progress;
        }
        else
        {
            $progress = 1;
        }
 
        $task->text = $request->name;
         $task->start_date =  $start_date;
         if (!empty($duration)) 
        {
            $end_date = date('Y-m-d', strtotime($start_date . ' + '.$duration.' days'));
            $task->task_end_date = $end_date;
        }
        $task->duration = $duration;
        $task->progress =  $progress;
        $task->parent = $request->parent;
        $task->description = $request->description;
        $task->task_priority =$request->priorty;
        $task->assign_to = $request->assign_to;
        $task->created_by = $request->created_by;
        $task->task_type = $request->task_type;

        if ($request->order_status == 'true') 
        {
          $task->node_name = 'leaf';
        }

        $task->save();

        // if ($request->parent != 0) 
        //  {
        //     Link::where([['source' , $task_parent] , ['target' , $task->id]])->update([
        //         'type' => 1,
        //         'source' =>$request->parent,
        //         'target' => $task->id,
        //     ]);
        //  }


        if ($request->order_status == 'true') 
        {
              
        //................Add bill Of quantity .......................//

            if( $task->id > 0 && !empty($request->items))
        {
            
            billOfQuantity::where('task_id' , $task->id)
            ->whereNotIn('item_id', array_column($request->items, 'item_id'))
            ->delete();


            for ($item = 0; $item < sizeof( $request->items); $item++) 
            {
                if (empty($request->items[$item]['item_id']) || $request->items[$item]['item_id'] == 0)
                {
                    DB::rollback();
                    return json_encode(array('response' => 'custom_error' , 'errors' => 'Please Select item(s)'));
                    exit();
                }

                if (empty($request->items[$item]['quantity']) || $request->items[$item]['quantity'] == 0)
                {
                    DB::rollback();
                      return json_encode(array('response' => 'custom_error' , 'errors' => 'Please add valid item(s) quantity.'));
                    exit();
                }

                if (empty($request->items[$item]['price']) || $request->items[$item]['price'] == 0)
                {
                    DB::rollback();
                     return json_encode(array('response' => 'custom_error' , 'errors' => 'Please add valid item(s) rate per unit'));
                    exit();
                }


                $current_item = Item::find($request->items[$item]['item_id']);

                if(($current_item->quantity + $request->items[$item]['quantity']) > $current_item->maxqty)
                {
                   $validOrderQty = $current_item->maxqty - $current_item->quantity;

                   if($validOrderQty <= 0 )
                   {
                     $validOrderQty = 0;
                   }

                     echo json_encode(array('response' => 'custom_error' , 'errors' => 'Item <b>'.$current_item->item_name.' </b> has max order Quantity is '.$current_item->maxqty.'. you  have already '.$current_item->quantity.' . you can only order now '. ( $validOrderQty ).' .'));
                     DB::rollback();
                     exit();
                }

                    $insert_new_items = billOfQuantity::where('task_id', '=', $task->id)
                    ->where( 'item_id', $request->items[$item]['item_id'])
                    ->first();

                      if($insert_new_items == false)
                {
                 billOfQuantity::create([
                    'task_id' => $task->id,
                    'item_id' => $request->items[$item]['item_id'],
                    'quantity' => $request->items[$item]['quantity'],
                    'rate_per_unit' => $request->items[$item]['price'],
                    'total_cost' => $request->items[$item]['quantity'] * $request->items[$item]['price'],
              ]);
             }


               if($insert_new_items == true)
            {
                billOfQuantity::where('task_id', '=', $task->id)
                ->where( 'item_id', $request->items[$item]['item_id'])
                ->update([
                    'quantity' => $request->items[$item]['quantity'],
                    'rate_per_unit' => $request->items[$item]['price'],
                    'total_cost' => $request->items[$item]['quantity'] * $request->items[$item]['price'],
              ]);
            }

            }
 
       
            $total_task_cost=billOfQuantity::where('task_id' , $task->id)->sum('total_cost');
          
            Task::where('id' , $task->id)->update([
             'total_cost' =>  $total_task_cost,
            ]);
        }

        //...............Update Parent Nodes...........................//

         $this->updateParentNodes($request->parent);

        }
 
        DB::commit();

          return response()->json([
            "response"=> "updated",
            'message' => 'Work Order Updated Successfully!',
            "tid" => $task->id
        ]);
      
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
        
      }

    }
 
      public function destroy($id)
      {
        dd($id);

        DB::beginTransaction();

        try {

            $task = Task::find($id);
            $task->delete();
            billOfQuantity::where('task_id' , $task->id)->delete();

            $this->updateParentNodes($task->parent);
            DB::commit();
            return redirect()->back()->with('success' , 'Work order Remove Successfully.');
        }
        catch (\Exception $e) 
        {
            DB::rollback();
            
            return redirect()->back()->with('error' , 'Something went wrong! Record Not Deleted.');
        }
      }

      public function boqView(Request $request)
      {
          $boq_id = $request->id;
          $task = Task::find($boq_id);
          $boq_array = array();
          $boqs = $task->boq;
          $total_ammount = 0;

          if ($task == true)
           {
                foreach ($boqs as $key => $boq) 
                {
                   $total_ammount += $boq->total_cost;

                   $boq_array[] = array( 'item_name' => $boq->item->item_name , 'item_unit' => $boq->item->unit , 'quantity' => $boq->quantity , 'rate_per_unit' => number_format($boq->rate_per_unit , 2) , 'total_cost' => number_format($boq->total_cost ,2) , 'date' => date('d-F-Y' , strtotime($boq->created_at)) );
                }

                echo json_encode(array('response' =>'found' ,'task' => $task, 'boq' => $boq_array , 'total_ammount' => number_format($total_ammount , 2)));
          }
      
      }

}
