<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\TransferProperty;
use App\Customer;
use App\CustomerProperty;
use App\CustomerStatement;
use App\Country;
use App\DepositorBank;
use App\CompanyBank;
use App\Receipt;
use App\TransferPropertyHistory;
use Illuminate\Support\Facades\Auth;
use App\MultiProject;

class TransferPropertyController extends Controller
{
    protected $transfer;

    public function __construct() {
        $this->transfer = new TransferProperty();
    }
    
    public function getAllTransfers() {
        $project_ids=   $this->getCookieInfomation();
        if($project_ids['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        $ids=[];
        if(is_array($project_ids['multi_projects'])){
            $ids= $project_ids['multi_projects']; 
        }
        else
        $ids[]= $project_ids['multi_projects'];

        $allTransfers = TransferProperty::
        whereHas('property', function($query) use($ids){
            $query->whereIn('multi_project_id', $ids);
                 
        })->
        orderBy('transfer_date','desc')->get();
        return view('statement/transfer.index',compact('allTransfers'));
    }

    public function addTransferForm() {

        $data['customers'] = Customer::orderBy('name','asc')->get();
        // $data['properties'] = CustomerProperty::where('status','!=',CustomerProperty::cancel)->with('inventory')->get();
        $project_ids=   $this->getCookieInfomation();
        if($project_ids['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
       
        $ids=[];
        if(is_array($project_ids['multi_projects'])){
            $ids= $project_ids['multi_projects']; 
        }
        else
        $ids[]= $project_ids['multi_projects'];

        $data['properties'] =     CustomerProperty::where('status', '!=', CustomerProperty::cancel)
        ->has('inventory')
        ->whereHas('inventory',function ($query) use ($ids) {
            $query->whereHas('noc', function ($query) use ($ids) {
                $query->where('status', 1)->whereIn('multi_project_id', $ids);
                
            });
        })
         
        ->get();
       
        $data['banks'] = DepositorBank::all();
        $data['cBanks'] = CompanyBank::all();
        $result = Receipt::where([['receipt_no', '!=', null]])->orderby('receipt_no', 'desc')
            ->first();
        if($result)
        {
            $data['receipt_no'] = ++$result->receipt_no;
        }
        else{
            $data['receipt_no'] = '50000';
        }

        return view('statement/transfer.add-transfer',$data);
    }

    public function insertTransfer(Request $request) {

        $messages = [
            'name.required_if' => 'The Name field is required.',
            'cnic.required_if' => 'The Cnic field is required.',
            'father_name.required_if' => 'The S/O field is required.',
            'mobile_number.required_if' => 'The phone number field is required.',
            'nominee_name.required_if' => 'The Nominee name field is required.',
            'nominee_so_do_wo.required_if' => 'The Nominee S/O D/O W/O field is required.',
            'nominee_cnic.required_if' => 'The Nominee Cnic field is required.',
            'nominee_relation.required_if' => 'The Nominee Relation field is required.',
            'permanent_address.required_if' => 'The permanent address field is required.',
            'mailing_address.required_if' => 'The mailing address field is required.',
            'dob.required_if' => 'The dob field is required.',
            ];

        $validator = Validator::make($request->all(), [
                    'property_id' => 'required',
                    
                    // 'old_client_id' => 'required',
                    'transfer_charges' => 'required',
                    'transfer_date' => 'required',
                    //'transfer_note' =>'required',
                    'payment_mode' => 'required',
                    'payment_head' => 'required',
                    'receipt_date' => 'required',
                    'cheque_number'=>'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
                   // 'receipt_no' => 'required',
                    'receipt_no' => 'nullable|unique:receipts,receipt_no',
                    'name' => 'nullable|required_if:customer_id,|regex:/^[a-zA-Z\s,.-]+$/u',
                    'father_name' => 'nullable|required_if:customer_id,|regex:/^[a-zA-Z\s,-.]+$/u',
                    'cnic' => 'unique:customers,cnic|nullable|required_if:customer_id,',
                    'permanent_address' => 'nullable|required_if:customer_id,|',
                    'mailing_address' => 'nullable|required_if:customer_id,|',
                    'dob' => 'nullable|required_if:customer_id,|',
                    'mobile_number' => 'nullable|required_if:customer_id,|',
                    'nominee_name' => 'nullable|required_if:customer_id,',
                    'nominee_so_do_wo' => 'nullable|required_if:customer_id,|regex:/^[a-zA-Z\s,-.]+$/u',
                    'nominee_relation' => 'nullable|required_if:customer_id,|regex:/^[a-zA-Z\s,-.]+$/u',
        ],$messages);

        if ($validator->fails()) {
            return redirect('/transfer/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
 
    

        $result = $this->transfer->insertNewTransfer($request);

        if(!$result) {
             return redirect('/transfer/add')
                             ->withInput()
                             ->with([
                                 'message' => 'Something went wrong!',
                                 'alert-type' => 'error',
             ]);
         }

         activity('Transfer')->log($result->inventory->polot_number .' transfer to '. $result->customer->name);

       return redirect()
                        ->route('transfer.all')
                        ->with([
                            'message' => 'Statement created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function detailTransfer($id) {

        $transfer = TransferProperty::where('id',$id)->first();

        $allTransfers = TransferProperty::where('property_id',$transfer->property_id)->get();

        $duration = array();
        $fromDate = null;
        $toDate = null;
        foreach ($allTransfers as $t) {
            if($fromDate == null) {
                $fromDate = $t->property->booking_date;
                $toDate = $t->transfer_date;
            }
            else {
                $fromDate = $toDate;
                $toDate = $t->transfer_date;
            }

            $duration[$t->id] = date('d-m-Y',strtotime($fromDate)) . '  :  ' . date('d-m-Y',strtotime($toDate));

        }

        return view('statement/transfer.detail-transfer',compact('transfer','allTransfers','duration'));
    }

     public function updateInfo(Request $request) {

        $property['info'] = CustomerProperty::with('inventory')->where('id',$request->id)->with('customer','size')->first();

        $property['received'] = CustomerStatement::where('customer_property_id',$request->id)->sum('received');
        $property['due'] = CustomerStatement::where('customer_property_id',$request->id)->where('due_date','<=',\Carbon\Carbon::now()->endOfMonth())->value(\DB::raw("SUM(balance)"));


        return $property;
    }
    public  function getCookieInfomation(){
        try{
        $data = array();
        $project_id = request()->cookie('current_project_id');
        $user = Auth::user();
        if (!empty($project_id)) {
            $p_id = decrypt($project_id);
            $multi = MultiProject::where('id', $p_id)->first();
            $multiProjectId = $multi->id;
            if ($multi->name == "Super Admin") {
                $roles = $user
                    ->roles()
                    ->where('name', 'like', 'admin')
                    ->whereHas('projects', function ($query) use ($multiProjectId) {
                        $query->where('multi_project_id', $multiProjectId);
                    })
                    ->first();
                if (!empty($roles)) {
                    $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get()->pluck('id')->toArray() // Flatten the collection of IDs into a single array
                    ;
                    $data['status'] = 'success';
                    return   $data;
                           
                } else {
                    $request = app(Request::class);
               
                    $permission=decrypt($request->permission);
                    
                    $project_ids=       $user->roles()
                   ->whereHas('projects', function ($query)   {
                   $query->where('name', 'NOT like', 'Super Admin');
                   })
                   ->get()
                   ->filter(function ($r) use ($permission) {
                   return $r->hasPermission($permission);
                   })
                   ->pluck('projects.*.id') // Pluck the 'id' column from the remaining 'projects' models
                   ->flatten() // Flatten the collection of IDs into a single array
                   ->unique()
                   ->toArray()
                   ;
                   
                   if(sizeof($project_ids) == 0)
                   {
                       $data['status'] = 'error';
                       return  $data; 
                   }
    
                     
                    $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get()->pluck('id')
                    ->toArray();
                    $data['status'] = 'success';
                    return   $data;
                           
                     
                }
            }
            else{
                $roles = $user
                    ->roles()
                    
                    ->whereHas('projects', function ($query) use ($multiProjectId) {
                        $query->where('multi_project_id', $multiProjectId);
                    })
                    ->first(); 
    
                    if (!empty($roles)) {
                        $data['multi_projects']  = $multi->id;
                        
                        $data['status'] = 'success';
                        return   $data;
                               
                        
    
                    }
            }
        }
        else
        {
            $data['status'] = 'error';
            return  $data; 
        }
    }
        catch(\Exception $e){
            $data['status'] = 'error';
            return  $data;
        
        }
    }
}
