<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Customer;
use App\Inventory;
use App\CustomerProperty;
use App\Receipt;
use App\CompanyBank;
use App\CompanyBankTransaction;
use App\CustomerRefundUnitReceipt;
use App\CustomerCancelUnitReceipt;
use App\Dealer;
use App\DealerPaidRebate;
use App\UnitType;
use App\UnitSize;
use App\UnitCategory;
use App\UnitFloor;
use App\CustomerStatement;
use App\OpenFilePackage;
use App\PriceList;
use App\DealerPackage;
use App\DealerPackageReceipt;
use App\DealerRefundOpenFileUnitReceipt;
use App\DealerOpenFileCancelReceipt;
use Illuminate\Support\Facades\DB;



class TrashController extends Controller
{
    protected $customer,$property,$receipt;

    public function __construct() {

        $this->customer = new Customer();
        $this->property = new CustomerProperty();
        $this->receipt = new Receipt();

    }

    public function getAllTrashItem() {

        $data = array();

        $data['allCustomers'] = Customer::orderBy('created_at', 'desc')->where('is_deleted',true)->get();

        $data['allInventories'] = Inventory::orderBy('created_at','desc')->where('is_deleted',true)->get();

        $data['allStatements'] = CustomerProperty::with('inventory','customer')->orderBy('created_at', 'desc')->where('is_deleted',true)->get();

        $data['receipts'] = Receipt::with('property')->where('is_deleted',true)->orderBy('id','desc')->get();

        $data['allDealers'] = Dealer::with('dealerType')->where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allDealerRebate'] = DealerPaidRebate::where('is_deleted',true)->with('dealer')->orderBy('created_at', 'desc')->get();

        $data['allUnitType'] = UnitType::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allUnitSize'] = UnitSize::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allUnitFloor'] = UnitFloor::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allUnitCategory'] = UnitCategory::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allpackage'] = OpenFilePackage::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allprice'] = PriceList::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allopenfile'] = DealerPackage::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allDealerReceipt'] = DealerPackageReceipt::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allRefundUnitReceipt'] = CustomerRefundUnitReceipt::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allRefundOpenFileReceipt'] = DealerRefundOpenFileUnitReceipt::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        $data['allCancelUnitReceipt'] = CustomerCancelUnitReceipt::where('is_deleted',true)->orderBy('created_at', 'desc')->get();
        
        $data['allCancelOpenFileReceipt'] = DealerOpenFileCancelReceipt::where('is_deleted',true)->orderBy('created_at', 'desc')->get();

        activity('View')->log('Trash Box.');

        return view('trash.index',$data);
    }

    public function revertCustomer($id) {

        // $this->customer->deleteCustomer($id);
        $cus =  Customer::where('id',$id)->first();

        Customer::where('id',$id)->update(['is_deleted'=>false]);

        CustomerProperty::where('customer_id',$id)->update(['is_deleted'=>false]);

        Receipt::where('customer_id',$id)->update(['is_deleted'=>false]);

        $amount = Receipt::where([['customer_id',$id],['is_deleted',false]])->sum('amount');

        Customer::where('id',$id)->update(['total_paid_amount'=>$amount]);

        activity('Revert')->log('Revert the Customer '.$cus->name);

        return redirect()->back()->with([
                    'message' => 'Customer Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteCustomer($id) {

        $cus =  Customer::where('id',$id)->first();

        $this->customer->deleteCustomer($id);

        activity('Delete')->log('Permanent Delete the Customer '.$cus->name);

        return redirect()->back()->with([
                    'message' => 'Customer deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllCustomers()
    {
        $records = Customer::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = Customer::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Customers From Trash');


        return redirect()->back()->with([
            'message' => 'All Customers have been deleted Successfully!',
            'alert-type' => 'info',
        ]);
    }

    public function revertInventory($id) {

        $inv = Inventory::where('id',$id)->first();

        Inventory::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Inventory '.$inv->unit_number);

        return redirect()->back()->with([
                    'message' => 'Inventory Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteInventory($id) {

        $inv = Inventory::where('id',$id)->first();

        Inventory::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Inventory '.$inv->unit_number);

        return redirect()->back()->with([
                    'message' => 'Inventory deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllInventories()
    {
        $records = Inventory::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = Inventory::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Inventories From Trash');

        return redirect()->back()->with([
            'message' => 'All Inventories have been deleted Successfully!',
            'alert-type' => 'info',
        ]);
    }

    

    public function revertMembership($id) {

        $pro = CustomerProperty::where('id',$id)->with('inventory','customer')->first();

        CustomerProperty::where('id',$id)->update(['is_deleted'=>false]);

        Receipt::where('customer_property_id',$pro->id)->update(['is_deleted'=>false]);

        $amount = Receipt::where([['customer_id',$pro->customer_id],['is_deleted',false]])->sum('amount');

        Customer::where('id',$pro->customer_id)->update(['total_paid_amount'=>$amount]);


        activity('Revert')->log('Revert the property info '. $pro->inventory->unit_number . $pro->customer->name);

        return redirect()->back()->with([
                    'message' => 'Statement Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteMembership($id) {

        $pro = CustomerProperty::where('id',$id)->with('inventory','customer')->first();

        $this->property->deleteProperty($id);

        activity('Delete')->log('Permanent Delete the property info '. $pro->inventory->unit_number . $pro->customer->name);

        return redirect()->back()->with([
                    'message' => 'Statement deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllMemberships()
    {
        $records = CustomerProperty::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = CustomerProperty::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Statements From Trash');


        return redirect()->back()->with([
            'message' => 'All Statements have been deleted Successfully!',
            'alert-type' => 'info',
        ]);
    }

    public function revertReceipt($id) {

        $receipt = Receipt::where('id',$id)->first();

        Receipt::where('id',$id)->update(['is_deleted'=>false]);

        if($receipt->is_approved) {

            $amount = Receipt::where([['customer_id',$receipt->customer_id],['is_deleted',false]])->sum('amount');

            Customer::where('id',$receipt->customer_id)->update(['total_paid_amount'=>$amount]);

            CustomerStatement::where('receipt_id',$id)->update(['is_deleted'=>false]);
        }

        activity('Revert')->log('Revert Receipt info '. $receipt->receipt_no);

        return redirect()->back()->with([
                    'message' => 'Receipt Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteReceipt($id) {

        $receipt = Receipt::where('id',$id)->first();

         if($receipt->is_approved) {

        //delete previous record
        $cBank = CompanyBank::where('id',$receipt->company_account)->first();
        if($cBank) 
        {
            CompanyBank::where('id',$receipt->company_account)->update(['amount'=>$cBank->amount - $receipt->amount ]);
            //make transation
            CompanyBankTransaction::where('receipt_id', $receipt->id)->delete();
        }

        $receipt = $this->receipt->deleteReceipt($id);

        $amount = Receipt::where([['customer_id',$receipt->customer_id],['is_deleted',false]])->sum('amount');

        Customer::where('id',$receipt->customer_id)->update(['total_paid_amount'=>$amount]);

    }
    else {
        Receipt::where('id',$id)->delete();
    }

        activity('Delete')->log('Permanent Delete Receipt info '. $receipt->receipt_no);

        return redirect()->back()->with([
                    'message' => 'Receipt deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllReceipts() {

        $records = Receipt::where('is_deleted', true)->get();

        foreach ($records as $record) {

         if($record->is_approved) {

        //delete previous record
        $cBank = CompanyBank::where('id',$record->company_account)->first();
        if($cBank) 
        {
            CompanyBank::where('id',$record->company_account)->update(['amount'=>$cBank->amount - $record->amount ]);
            //make transation
            CompanyBankTransaction::where('receipt_id', $record->id)->delete();
        }

        // $record = $this->record->deleteReceipt($id);
        $records = Receipt::where('id', $record->id)->delete();

        $amount = Receipt::where([['customer_id',$record->customer_id],['is_deleted',false]])->sum('amount');

        Customer::where('id',$record->customer_id)->update(['total_paid_amount'=>$amount]);

    }
    else {
        foreach ($records as $record) {
            $records = Receipt::where('id', $record->id)
            ->delete();
    }
}

        activity('Delete All')->log('Permanent Delete All Receipts From Trash');

        return redirect()->back()->with([
                    'message' => 'All Receipts deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }
}

    public function revertDealer($id) {

        $dealer = Dealer::where('id',$id)->first();

        Dealer::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert dealer info '. $dealer->name);

        return redirect()->back()->with([
                    'message' => 'Dealer Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteDealer($id) {

        $dealer = Dealer::where('id',$id)->first();

        Dealer::where('id',$id)->delete();

        activity('Delete')->log('Permanent Delete dealer info '. $dealer->name);

        return redirect()->back()->with([
                    'message' => 'Dealer deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllDealers()
    {
        $records = Dealer::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = Dealer::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Dealers From Trash');


        return redirect()->back()->with([
            'message' => 'All Dealers have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }


    public function revertDealerRebate($id) {

        $rebate = DealerPaidRebate::where('id',$id)->first();
        
         $dealer = Dealer::where('id',$rebate->dealer_id)->first();

        DealerPaidRebate::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert Dealer Rebate '. $dealer->name);

        return redirect()->back()->with([
                    'message' => 'Dealer Rebate Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteDealerRebate($id) {

        $rebate = DealerPaidRebate::where('id',$id)->first();
        
         $dealer = Dealer::where('id',$rebate->dealer_id)->first();
         
         Dealer::where('id',$rebate->dealer_id)->update(['total_paid_amount'=>$dealer->total_paid_amount - $rebate->amount]);

        DealerPaidRebate::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete Dealer Rebate '. $dealer->name);

        return redirect()->back()->with([
                    'message' => 'Dealer Rebate deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function revertUnitFloor($id) {

        UnitFloor::where('id', $id)->update(['is_deleted' =>false]);

        $p = UnitFloor::where('id',$id)->first();

        activity('Revert')->log('Revert Unit Floor '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Floor Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteUnitFloor($id) {

        $p = UnitFloor::where('id',$id)->first();
        
        UnitFloor::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete Unit Floor '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Floor deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllFloors()
    {
        $records = UnitFloor::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = UnitFloor::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Streets From Trash');


        return redirect()->back()->with([
            'message' => 'All Streets have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }

    public function revertUnitType($id) {

        UnitType::where('id', $id)->update(['is_deleted' =>false]);

        $p = UnitType::where('id',$id)->first();

        activity('Revert')->log('Revert Unit Type '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Type Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteUnitType($id) {

        $p = UnitType::where('id',$id)->first();
        
        UnitType::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete Unit Type '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Type deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllTypes()
    {
        $records = UnitType::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = UnitType::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Unit Types From Trash');


        return redirect()->back()->with([
            'message' => 'All Types have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }

    public function revertUnitSize($id) {

        UnitSize::where('id', $id)->update(['is_deleted' =>false]);

        $p = UnitSize::where('id',$id)->first();

        activity('Revert')->log('Revert Unit Size '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Size Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteUnitSize($id) {

        $p = UnitSize::where('id',$id)->first();
        
        UnitSize::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete Unit Size '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Size deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllSizes()
    {
        $records = UnitSize::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = UnitSize::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Sizes From Trash');


        return redirect()->back()->with([
            'message' => 'All Sizes have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }

    public function revertUnitCategory($id) {

        UnitCategory::where('id', $id)->update(['is_deleted' =>false]);

        $p = UnitCategory::where('id',$id)->first();

        activity('Revert')->log('Revert Unit Category '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Category Revert Successfully!',
                    'alert-type' => 'info',
        ]);

    }

    public function deleteUnitCategory($id) {

        $p = UnitCategory::where('id',$id)->first();
        
        UnitCategory::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete Unit Category '.$p->name);

        return redirect()->back()->with([
                    'message' => 'Unit Category deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function deleteAllCategories()
    {
        $records = UnitCategory::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = UnitCategory::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Categories From Trash');


        return redirect()->back()->with([
            'message' => 'All Categories have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }    

    public function revertPackage($id) 
    {
        $pkg = OpenFilePackage::where('id',$id)->first();

        OpenFilePackage::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Package ');

        return redirect()->back()->with([
        'message' => 'Package Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deletePackage($id)
    {
        $pkg = OpenFilePackage::where('id',$id)->first();

        OpenFilePackage::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Package ');

        return redirect()->back()->with([
        'message' => 'Package Deleted Permanantly!',
        'alert-type' => 'info',
    ]);
    }

    public function deleteAllPackages()
    {
        $records = OpenFilePackage::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = OpenFilePackage::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Packages From Trash');


        return redirect()->back()->with([
            'message' => 'All Packages have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    } 

    public function revertPrice($id)
    {
        $pri = PriceList::where('id',$id)->first();

        PriceList::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Price List '.$pri->l_no);

        return redirect()->back()->with([
        'message' => 'Price List Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deletePrice($id)
    {
        $pri = PriceList::where('id',$id)->first();

        PriceList::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Price List '.$pri->l_no);

        return redirect()->back()->with([
        'message' => 'Price List Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllPrices()
    {
        $records = PriceList::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = PriceList::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Price Lists From Trash');


        return redirect()->back()->with([
            'message' => 'All Price Lists have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    } 

    public function revertOpenFile($id)
    {
        $ofp = DealerPackage::where('id',$id)->first();

        DealerPackage::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Open File Dealer Package ');

        return redirect()->back()->with([
        'message' => 'Open File Dealer Package Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deleteOpenFile($id)
    {
        $ofp = DealerPackage::where('id',$id)->first();

        DealerPackage::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Open File Dealer Package ');

        return redirect()->back()->with([
        'message' => 'Open File Dealer Package Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllAllOpenFiles()
    {
        $records = DealerPackage::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = DealerPackage::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Open File Pacakges From Trash');


        return redirect()->back()->with([
            'message' => 'All Open File Dealer Packages have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    } 

    public function revertDealerReceipt($id)
    {
        $dpr = DealerPackageReceipt::where('id',$id)->first();

        DealerPackageReceipt::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Dealer Package Receipt');

        return redirect()->back()->with([
        'message' => ' Dealer Package Receipt Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deleteDealerReceipt($id)
    {
        $dpr = DealerPackageReceipt::where('id',$id)->first();

        DealerPackageReceipt::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Dealer Package Receipt');

        return redirect()->back()->with([
        'message' => ' Dealer Package Receipt Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllDealerPackageReceipts()
    {
        $records = DealerPackageReceipt::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = DealerPackageReceipt::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Dealer Package Receipts From Trash');

        return redirect()->back()->with([
            'message' => 'All Dealer Package Receipts have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }  
    
    



    public function revertRefundUnitReceipt($id)
    {
        $dpr = CustomerRefundUnitReceipt::where('id',$id)->first();

        CustomerRefundUnitReceipt::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Refund Unit Receipt');

        return redirect()->back()->with([
        'message' => ' Refund Unit  Receipt Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deleteRefundUnitReceipt($id)
    {
        $dpr = CustomerRefundUnitReceipt::where('id',$id)->first();

        CustomerRefundUnitReceipt::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Refund Unit Receipt');

        return redirect()->back()->with([
        'message' => 'Refund Unit  Receipt Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllRefundUnitReceipts()
    {
        $records = CustomerRefundUnitReceipt::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = CustomerRefundUnitReceipt::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All REfund Unit Receipts From Trash');

        return redirect()->back()->with([
            'message' => 'All Refund Unit Receipts have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }  

    public function revertRefundOpenFileReceipt($id)
    {
        $dpr = DealerRefundOpenFileUnitReceipt::where('id',$id)->first();

        DealerRefundOpenFileUnitReceipt::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Open File Refund Receipt');

        return redirect()->back()->with([
        'message' => ' Refund Open File Receipt Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deleteRefundOpenFileReceipt($id)
    {
        $dpr = DealerRefundOpenFileUnitReceipt::where('id',$id)->first();

        DealerRefundOpenFileUnitReceipt::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Open File Refund Receipt');

        return redirect()->back()->with([
        'message' => 'Refund Open File Receipt Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllRefundOpenFileReceipts()
    {
        $records = DealerRefundOpenFileUnitReceipt::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = DealerRefundOpenFileUnitReceipt::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Open File Refund Receipts From Trash');

        return redirect()->back()->with([
            'message' => 'All Open File Refund Receipts have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }  

    public function revertCancelUnitReceipt($id)
    {
        $dpr = CustomerCancelUnitReceipt::where('id',$id)->first();

        CustomerCancelUnitReceipt::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Cancel Unit Receipt');

        return redirect()->back()->with([
        'message' => ' Cancel Unit Receipt Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deleteCancelUnitReceipt($id)
    {
        $dpr = CustomerCancelUnitReceipt::where('id',$id)->first();

        CustomerCancelUnitReceipt::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Cancel Unit Receipt');

        return redirect()->back()->with([
        'message' => 'Cancel Unit Receipt Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllCancelUnitReceipts()
    {
        $records = CustomerCancelUnitReceipt::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = CustomerCancelUnitReceipt::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Cancel Unit Receipts From Trash');

        return redirect()->back()->with([
            'message' => 'All Cancel Unit Receipts have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }  

    public function revertCancelOpenFileReceipt($id)
    {
        $dpr = DealerOpenFileCancelReceipt::where('id',$id)->first();

        DealerOpenFileCancelReceipt::where('id',$id)->update(['is_deleted'=>false]);

        activity('Revert')->log('Revert the Cancel Open File Receipt');

        return redirect()->back()->with([
        'message' => ' Cancel Open File Receipt Revert Successfully!',
        'alert-type' => 'info',
        ]);

    }

    public function deleteCancelOpenFileReceipt($id)
    {
        $dpr = DealerOpenFileCancelReceipt::where('id',$id)->first();

        DealerOpenFileCancelReceipt::where('id', $id)->delete();

        activity('Delete')->log('Permanent Delete the Open File Cancel Receipt');

        return redirect()->back()->with([
        'message' => 'Open File Cancel Receipt Deleted Permanantly!',
        'alert-type' => 'info',
        ]);
    }

    public function deleteAllCancelOpenFileReceipts()
    {
        $records = DealerOpenFileCancelReceipt::where('is_deleted', true)->get();

        foreach ($records as $record) {
            $records = DealerOpenFileCancelReceipt::where('id', $record->id)
            ->delete();
        }

        activity('Delete All')->log('Permanent Delete All Open File Cancel Receipts From Trash');

        return redirect()->back()->with([
            'message' => 'All Open File Cancel Receipts have been deleted Successfully!',
            'alert-type' => 'info',
            ]);
    }  







}
