<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\UnitBlock;

class UnitBlockController extends Controller {

    

    public function __construct() {
       
    }

    //Get All the Unit Block
    public function allUnitBlocks() {

        $allUnitBlocks = UnitBlock::where([['is_deleted',false],['name','!=','N/A']])->orderBy('name', 'asc')->get();

        activity('View')->log('Unit Block List.');

        return view('Setting/unitBlock.index', compact('allUnitBlocks'));
    }

    //show the add new Unit Block form
    public function addUnitBlockForm() {

        return view('Setting/unitBlock.add-block');
    }

    //insert new unit Block record
    public function insertUnitBlock(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:unit_blocks,name'
        ]);

        if ($validator->fails()) {
            return redirect('/unit-block/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Unit Block
        $input=$request->all();
        UnitBlock::create($input);

        activity('Create')->log('New Block added '. $request->name);

        return redirect()
                        ->route('unit.block.all')
                        ->with([
                            'message' => 'Unit Block created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Unit Block
    public function detailUnitBlock($id) {

        $block = UnitBlock::where('id', $id)->first();

        return view('Setting/unitBlock.detail-block', compact('block'));
    }

    //show the edit Unit Block form
    public function editUnitBlockForm($id) {

        $block = UnitBlock::where('id', $id)->first();

        return view('Setting/unitBlock.edit-block', compact('block'));
    }

    //update the unit record
    public function updateUnitBlock(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required'

        ]);

        if ($validator->fails()) {
            return redirect('/unit-block/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Unit Block
        UnitBlock::where('id',$request->id)->update(['name'=>$request->name]);

        activity('Update')->log('Edit Block added '. $request->name);

        return redirect()
                        ->route('unit.block.all')
                        ->with([
                            'message' => 'Unit block updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Unit Block
    public function deleteUnitBlock($id) {

        UnitBlock::where('id', $id)->update(['is_deleted'=>true]);

        $p = UnitBlock::where('id',$id)->first();

        activity('Delete')->log('Delete Unit Block '.$p->name);

        return redirect()->route('unit.block.all')->with([
                    'message' => 'Unit block deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
