<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\UnitCategory;

class UnitCategoryController extends Controller {

    protected $unitCategory;

    public function __construct() {
        $this->unitCategory = new UnitCategory();
    }

    //Get All the UnitCategory
    public function allUnitCategories() {

        $allUnitCategories = UnitCategory::where([['is_deleted',false]])->orderBy('created_at', 'desc')->get();

        activity('View')->log('Unit Categories List.');

        return view('Setting/unitCategory.index', compact('allUnitCategories'));
    }

    //show the add new UnitCategory  form
    public function addUnitCategoryForm() {

        return view('Setting/unitCategory.add-category');
    }

    //insert new UnitCategory record
    public function insertUnitCategory(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s0-9]+$/u|unique:unit_categories,name',
                    'percent' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/unit-category/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new UnitCategory
        $input=$request->all();
        UnitCategory::create($input);

        activity('Create')->log('New Category added '. $request->name);

        return redirect()
                        ->route('unitCategory.all')
                        ->with([
                            'message' => 'Unit Category created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the UnitCategory
    public function detailUnitCategory($id) {

        $category = UnitCategory::where('id', $id)->first();

        return view('Setting/unitCategory.detail-category', compact('category'));
    }

    //show the edit UnitCategory form
    public function editUnitCategoryForm($id) {

        $category = UnitCategory::where('id', $id)->first();

        return view('Setting/unitCategory.edit-category', compact('category'));
    }

    //update the UnitCategory
    public function updateUnitCategory(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s0-9]+$/u',
                    'percent' => 'required',
                    'is_percent' => 'required'

        ]);

        if ($validator->fails()) {
            return redirect('/unit-category/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update unit Category
        UnitCategory::where('id',$request->id)->update(['name'=>$request->name,'percent'=>$request->percent,'is_percent' => $request->is_percent]);

        activity('Update')->log('Edit Category added '. $request->name);

        return redirect()
                        ->route('unitCategory.all')
                        ->with([
                            'message' => 'Unit Category updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific unitCategory
    public function deleteUnitCategory($id) {

        UnitCategory::where('id', $id)->update(['is_deleted'=>true]);

        $p = UnitCategory::where('id',$id)->first();

        activity('Delete')->log('Delete Unit Category '.$p->name);

        return redirect()->route('unitCategory.all')->with([
                    'message' => 'Unit Category deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
