<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\UnitFloor;
use App\UnitSize;
use App\UnitType;
use App\UnitOldRates;
use App\UnitFloorSize;
use App\UnitBlock;
use DB;

class UnitFloorController extends Controller {

    protected $unitFloor;

    public function __construct() {
        $this->unitFloor = new UnitFloor();
    }

    //Get All the UnitFloors
    public function allUnitFloors() {

        $allUnitFloors = UnitFloor::where([['is_deleted',false],['name','!=','N/A']])->with('unitFloors')->get();

        activity('View')->log('Unit Floor List.');

        return view('Setting/unitFloor.index', compact('allUnitFloors'));
    }

    //show the add new UnitFloor  form
    public function addUnitFloorForm() {

        $sizes = UnitSize::orderBy('name','asc')->get();
        $types = UnitType::get();
        $blocks = UnitBlock::where([['is_deleted',false],['name','!=','N/A']])->orderBy('name','asc')->get();

        return view('Setting/unitFloor.add-floor',compact('sizes','types','blocks'));
    }

    //insert new unitFloor record
    public function insertUnitFloor(Request $request) {

        
        $validator = Validator::make($request->all(), [
                    // 'name' => 'required|unique:unit_floors,name',
                    // 'unit_block_id' => 'required',
                    // 'unit_block_id' => 'required',
                    // 'name' => [
                    //     'required',
                    //     Rule::unique('unit_floors')->where(function ($query) use ($request) {
                    //         return $query->where('unit_block_id', $request->input('unit_block_id'));
                    //     }),
                    // ],
                    'unit_block_id' => 'required',
                    'name' => [
                        'required',
                        function ($attribute, $value, $fail) use ($request) {
                            $unit_block_id = $request->input('unit_block_id');
                            $count = DB::table('unit_floors')
                                     ->where('unit_block_id',    $unit_block_id)
                                     ->where('name', $value)
                                     ->count();
                            if ($count > 0) {
                                $fail('The '.$attribute.' must be unique for the selected unit block.');
                            }
                        }
                    ],
                   
                
                   
        ]);

        if ($validator->fails()) {
            return redirect('/unit-floor/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new unitfloor
        
        $this->unitFloor->insertUnitFloor($request);

        activity('Create')->log('New Floor added '. $request->name);

        return redirect()
                        ->route('unitFloor.all')
                        ->with([
                            'message' => 'Unit Floor created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the edit UnitFloor form
    public function editUnitFloorForm($id) {

        $floor = UnitFloor::where('id', $id)->with('unitFloors')->first();
        $sizes = UnitSize::orderBy('name','asc')->get();
        $types = UnitType::get();
        $blocks = UnitBlock::orderBy('name','asc')->get();

        return view('Setting/unitFloor.edit-floor', compact('floor','sizes','types','blocks'));
    }

    //update the UnitFloor
    public function updateUnitFloor(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s0-9]+$/u',
                    'unit_block_id' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect('/unit-floor/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update unit Floor
        $this->unitFloor->updateUnitFloor($request);

        activity('Update')->log('Edit Unit Floor ' . $request->name);

        return redirect()
                        ->route('unitFloor.all')
                        ->with([
                            'message' => 'Unit Floor updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific unitFloor
    public function deleteUnitFloor($id) {

        UnitFloor::where('id', $id)->update(['is_deleted' =>true]);

        $p = UnitFloor::where('id',$id)->first();

        activity('Delete')->log('Delete Unit floor '.$p->name);

        return redirect()->route('unitFloor.all')->with([
                    'message' => 'Unit Floor deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function getOldRates() {

        $allFloors = UnitFloor::all();

        $allUnitTypes = array();

        $allUnitRates = array();

        $newRates = array();

        foreach ($allFloors as $value) {
            $allUnitTypes[$value->id] = UnitFloorSize::where('unit_floor_id',$value->id)->get();

            foreach ($allUnitTypes[$value->id] as $value1) {
                $allUnitRates[$value->id][$value1->id] = UnitOldRates::groupBy('rate')->where([['unit_floor_id',$value->id],['unit_type_id',$value1->unit_type_id]])->orderBy('rate','ASC')->get();

                $newRates[$value->id][$value1->id] = UnitFloorSize::where([['unit_floor_id',$value->id],['unit_type_id',$value1->unit_type_id]])->first();
            }


        }

        return view('Setting/unitFloor.old-rates', compact('allFloors','allUnitTypes','allUnitRates','newRates'));
    }

}
