<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\UnitSize;

class UnitSizeController extends Controller {

    protected $unitSize;

    public function __construct() {
        $this->unitSize = new UnitSize();
    }

    //Get All the Product Size
    public function allUnitSizes() {

        $allUnitSizes = UnitSize::where([['is_deleted',false]])->orderBy('name', 'asc')->get();

        activity('View')->log('Unit Size List.');

        return view('Setting/unitSize.index', compact('allUnitSizes'));
    }

    //show the add new Unit Size  form
    public function addUnitSizeForm() {

        return view('Setting/unitSize.add-size');
    }

    //insert new unit Size record
    public function insertUnitSize(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:unit_sizes,name',
                    'status' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/unit-size/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Unit Size
        $input=$request->all();
        UnitSize::create($input);

        activity('Create')->log('New Size added '. $request->name);

        return redirect()
                        ->route('unit.size.all')
                        ->with([
                            'message' => 'Unit size created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Unit Size
    public function detailUnitSize($id) {

        $size = UnitSize::where('id', $id)->first();

        return view('Setting/unitSize.detail-size', compact('size'));
    }

    //show the edit Unit Size form
    public function editUnitSizeForm($id) {

        $size = UnitSize::where('id', $id)->first();

        return view('Setting/unitSize.edit-size', compact('size'));
    }

    //update the unit record
    public function updateUnitSize(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'status' => 'required',

        ]);

        if ($validator->fails()) {
            return redirect('/unit-size/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Unit Size
        UnitSize::where('id',$request->id)->update(['name'=>$request->name,'status'=>$request->status]);

        activity('Update')->log('Edit Szie added '. $request->name);

        return redirect()
                        ->route('unit.size.all')
                        ->with([
                            'message' => 'Unit size updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Unit Size
    public function deleteUnitSize($id) {

        UnitSize::where('id', $id)->update(['is_deleted'=>true]);

        $p = UnitSize::where('id',$id)->first();

        activity('Delete')->log('Delete Unit Size '.$p->name);

        return redirect()->route('unit.size.all')->with([
                    'message' => 'Unit size deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
