<?php

namespace App\Http\Controllers;

use App\ProjectType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\UnitType;

class UnitTypeController extends Controller {

    protected $unitType;

    public function __construct() {
        $this->unitType = new UnitType();
    }

    //Get All the UnitType
    public function allUnitTypes() {

        $allUnitTypes = UnitType::where([['is_deleted',false]])->orderBy('created_at', 'desc')->get();

        activity('View')->log('Unit Type List.');

        return view('Setting/unitType.index', compact('allUnitTypes'));
    }

    //show the add new UnitType  form
    public function addUnitTypeForm() {

        return view('Setting/unitType.add-type');
    }

    //insert new UnitType record
    public function insertUnitType(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s0-9]+$/u|unique:unit_types,name',
                    'status' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/unit-type/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new UnitType
       $pt= ProjectType::where('status', 1)->first();
        $request->merge([
            'projecttype_id' => $pt->id
        ]);
    
        $input=$request->all();
        UnitType::create($input);

        activity('Create')->log('New Type added '. $request->name);

        return redirect()
                        ->route('unit.type.all')
                        ->with([
                            'message' => 'Unit Type created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the UnitType
    public function detailUnitType($id) {

        $type = UnitType::where('id', $id)->first();

        return view('Setting/unitType.detail-type', compact('type'));
    }

    //show the edit UnitType form
    public function editUnitTypeForm($id) {

        $type = UnitType::where('id', $id)->first();

        return view('Setting/unitType.edit-type', compact('type'));
    }

    //update the unitType
    public function updateUnitType(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s0-9]+$/u',
                    'status' => 'required',

        ]);

        if ($validator->fails()) {
            return redirect('/unit-type/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update unitType
        UnitType::where('id',$request->id)->update(['name'=>$request->name,'status'=>$request->status]);

        activity('Update')->log('Edit Type added '. $request->name);

        return redirect()
                        ->route('unit.type.all')
                        ->with([
                            'message' => 'Unit Type updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific unitType
    public function deleteUnitType($id) {

        UnitType::where('id', $id)->update(['is_deleted'=>true]);

        $p = UnitType::where('id',$id)->first();

        activity('Delete')->log('Delete Unit Type '.$p->name);

        return redirect()->route('unit.type.all')->with([
                    'message' => 'Unit Type deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
