<?php

namespace App\Http\Controllers;

use App\Coupon;
use App\PointsHistory;
use App\Reward;
use Illuminate\Http\Request;
use App\Otp;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use App\Mail\OtpMail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class UserController extends Controller
{

    /**
     * Sends an OTP to the user and return whether the user was already registered or not.
     */
    public static function requestOTP(Request $request)
    {
        // lets convert the mobile number to our preffered format
        $formattedNumber = UtilsController::reformatMobileNumber($request->phone_number);
        $request->merge(['phone_number' => $formattedNumber]);

        // applying the validation rules
        $validator = Validator::make($request->all(), [
            'phone_number' => 'required|size:11',
        ]);


        if ($validator->fails()) {
            $errors['errors'] = $validator->messages();
            return UtilsController::apiResponse(false, "Incorrect input", $errors);
        }

        //setting up variables
        $phone_number = $request->phone_number;


        // lets find the user
        $userExists = User::where('phone_number', $phone_number)->first() !== null;


        // lets manage the OTP
        $lastOTP = null;
        if ($userExists) {
            // let's get the older OTP
            $lastOTP = Otp::getLastLoginOTPWithinLastHour($phone_number);


            // if no previous OTP, then create a new one
            if ($lastOTP == null) {
                $lastOTP = Otp::createLoginOTP($phone_number);
            }
        } else {
            $response['userAlreadyExists'] = $userExists;
            return UtilsController::apiResponse(false, "Number Not Exists.", $response);
        }

        $user = User::where('phone_number', $phone_number)->first();
        // send OTP to customer
        $number = "0092" . substr($phone_number, 1);
        $message = "Use the following OTP for logging in to hamdardCity portal: " . $lastOTP->otp;
        SmsController::sendSMS($number, $message);
        Mail::to($user->email)->send(new OtpMail($user,$lastOTP));

        $response['userAlreadyExists'] = $userExists;
        return UtilsController::apiResponse(true, "OTP sent.", $response);
    }


    public function login(Request $request)
    {
        // lets convert the mobile number to our preffered format
        $formattedNumber = UtilsController::reformatMobileNumber($request->phone_number);
        $request->merge(['phone_number' => $formattedNumber]);

        // applying the validation rules
        $validator = Validator::make($request->all(), [
            'phone_number' => 'required|size:11',
            'otp' => 'required',
        ]);


        if ($validator->fails()) {
            $errors['errors'] = $validator->messages();
            return UtilsController::apiResponse(false, "Incorrect input", $errors);
        }


        $phone_number = $request->phone_number;
        $otp = $request->otp;


        // lets find the user
        $user = User::where('phone_number', $phone_number)->first();

        // if user doesn't exist, we will create
        if (!$user) {
        	activity('Login')->log('login attemp failed' . $phone_number);
            return UtilsController::apiResponse(false, "User not found.");
        }


        // lets verify the OTP first
        $lastOTP = Otp::getLastLoginOTPWithinLastHour($phone_number);


        if ($lastOTP == null || $lastOTP->otp != $otp) {
        	activity('Login')->log('login attemp failed' . $phone_number);
            return UtilsController::apiResponse(false, "Incorrect OTP");
        }

         // let's login the user
        auth()->login($user);

        $previous_session = Auth::User()->session_id;

        if($previous_session) {
            Session::getHandler()->destroy($previous_session);
        }

        Auth::user()->session_id = Session::getId();
        Auth::user()->save();
        
        //send notification to Admin
        SmsController::sendSMS('00923124999213',$user->name . ' has logged in in the system at '. Carbon::now());

        activity('Login')->log('login ' . Auth::user()->name);

        $response["user"] = $user;
        return UtilsController::apiResponse(true, "Logged in successfully.", $response);
    }
}
