<?php

namespace App\Http\Controllers;

use App\Config;
use App\PointsHistory;
use App\PurchasePointsConfig;
use App\Reward;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\ChartOfAccount;
use App\GeneralJournalEntry;
use App\Customer;
use App\Dealer;
use App\Vendor; 

class UtilsController extends Controller
{
    /**
     * returns a formatted api response with optional message and data
     */
    public static function apiResponse(bool $success, string $msg = null, $data = null)
    {
        return [
            "success" => $success,
            "message" => $msg,
            "data" => $data
        ];
    }


    /**
     * return a transformed mobile number in format 03XXXXXXXX or null
     */
    public static function reformatMobileNumber($number)
    {
        // length should be 14(00923xxxxxxxxx) or 13(+923xxxxxxxxx) or 11(03xxxxxxxxx)
        if (strlen($number) == 14 && self::startsWith($number, "00923")) {
            // removing 092 if present at the start and replacing with 0
            $number = "0" . substr($number, 4);
        } else if (strlen($number) == 13 && self::startsWith($number, "+923")) {
            // removing +92 if present at the start and replacing with 0
            $number = "0" . substr($number, 3);
        } else if (strlen($number) == 11 && self::startsWith($number, "03")) {
            // dont do any thing
        } else {
            return null;
        }

        // remaining number should be 11 digits long and start with 03
        if (strlen($number) != 11 || !self::startsWith($number, "03"))
            return null;

        // it should contain only digits
        if (!ctype_digit($number))
            return null;

        return $number;
    }

    static function startsWith($haystack, $needle)
    {
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }

    static function endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if ($length == 0) {
            return true;
        }

        return (substr($haystack, -$length) === $needle);
    }


    public static function randomString($length): string
    {
        $seed = str_split('abcdefghijklmnopqrstuvwxyz'
            . 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
            . '0123456789'); // and any other characters
        shuffle($seed); // probably optional since array_is randomized; this may be redundant
        $rand = '';
        foreach (array_rand($seed, $length) as $k) {
            $rand .= $seed[$k];
        }
        return $rand;
    }

    public function testMethod(Request $request)
    {
//        dd($request->price);
        Reward::createOrUpdate(
            $request->points,
            $request->reward
        );
    }

    public static function  addGeneralEntry($debitAccount,$creditAccount,$amount,$memo,$name,$name_type,$date,$type) {


        //get the latest entry numeber
        $lastEntry = GeneralJournalEntry::orderBy('id','DESC')->first();
        if($lastEntry)
            $latestEntryNo = ++$lastEntry->entry_no;
        else
            $latestEntryNo = 1;

        //get The Debit Account Id
        $debitAccount = ChartOfAccount::where('name',$debitAccount)->first()->id;
        $creditAccount = ChartOfAccount::where('name',$creditAccount)->first()->id;

        //Debit Entry
        GeneralJournalEntry::create(['date'=>$date,'entry_no'=>$latestEntryNo,'adjusting_entry'=>0,'account_id'=>$debitAccount,'amount'=>$amount,'memo'=>$memo,'name'=>$name,'name_type'=>$name_type,'type'=>$type,'class_id'=>env('PROJECT_ID')]);

        //Credit Entry
        GeneralJournalEntry::create(['date'=>$date,'entry_no'=>$latestEntryNo,'adjusting_entry'=>0,'account_id'=>$creditAccount,'amount'=>$amount * -1,'memo'=>$memo,'name'=>$name,'name_type'=>$name_type,'type'=>$type,'class_id'=> env('PROJECT_ID')]);
    }
}
