<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Vendor;
use App\ExpensePayment;
use App\Expense;

class VendorController extends Controller {

    protected $vendor;

    public function __construct() {
        $this->vendor = new Vendor();
    }

    //Get All the Vendors
    public function allVendors() {

        $data['allVendors'] = Vendor::orderBy('created_at', 'desc')->get();

        $billAmount = array();
        $paidAmount = array();

        foreach($data['allVendors'] as $v) {
            $billAmount[$v->id] = Expense::where('vendor_id',$v->id)->sum('amount');
            $venId = $v->id;
            $paidAmount[$v->id] = ExpensePayment::whereHas('bill',function($query) use($venId) {
                $query->where('vendor_id',$venId);
            })->sum('amount');

        }

        $data['billAmount'] = $billAmount;
        $data['paidAmount'] = $paidAmount;

        return view('vendor.index', $data);
    }

    //show the add new Vendor  form
    public function addVendorForm() {

        return view('vendor.add-vendor');
    }

    //insert new Vendor record
    public function insertVendor(Request $request) {



        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'status' => 'required',
                    'opening_balance' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/vendor/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Vendor
        //Vendor::create(Input::all());
        $input=$request->all();
        Vendor::create($input);

        return redirect()
                        ->route('vendor1.all')
                        ->with([
                            'message' => 'Vendor created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Vendor
    public function detailVendor($id) {

        $data['vendor'] = Vendor::where('id', $id)->first();

        $data['billAmount'] = Expense::where('vendor_id',$id)->sum('amount');
        $venId = $id;
        $data['paidAmount'] = ExpensePayment::whereHas('bill',function($query) use($venId) {
                $query->where('vendor_id',$venId);
            })->sum('amount');

        $payments = ExpensePayment::whereHas('bill',function($query) use($venId) {
                $query->where('vendor_id',$venId);
            })->get();

        $bills = Expense::where('vendor_id',$id)->get();

        $records = array();

        foreach ($payments as $p) {
            if($p->bill->category)
                $category = $p->bill->category->name;
            else
                $category = 'Other';
            $newRecord = ['bill_id'=>'Payment Against Bill-000'.$p->bill->id,'date'=>$p->date,'amount'=>$p->amount,'category'=>$category,'memo'=>$p->notes,'bill'=>false,'created_at'=>$p->created_at];

            array_push($records,$newRecord);
        }

        foreach ($bills as $b) {
            if($b->category)
                $category = $b->category->name;
            else
                $category = 'Other';
            $newRecord = ['bill_id'=>'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bill-000'.$b->id,'date'=>$b->billed_at,'amount'=>$b->amount,'category'=>$category,'memo'=>$b->notes,'bill'=>true,'created_at'=>$b->created_at];

            array_push($records,$newRecord);
        }

        $data['records']  = collect($records)->sortBy('date')->sortBy('created_at')->all();

        $data['bill_count'] = count($bills);

        return view('vendor.detail-vendor', $data);
    }

    //show the edit Vendor form
    public function editVendorForm($id) {

        $vendor = Vendor::where('id', $id)->first();

        return view('vendor.edit-vendor', compact('vendor'));
    }

    //update the Vendor
    public function updateVendor(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'status' => 'required',
                    
        ]);

        if ($validator->fails()) {
            return redirect('/vendor/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Vendor
        Vendor::where('id',$request->id)->update(['name'=>$request->name,'email'=>$request->email,'phone_number'=>$request->phone_number,'address'=>$request->address,'status'=>$request->status,'cnic'=>$request->cnic,'rep_name'=>$request->rep_name ]);

        return redirect()
                        ->route('vendor1.all')
                        ->with([
                            'message' => 'Vendor updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Vendor
    public function deleteVendor($id) {

        Vendor::where('id', $id)->delete();

        return redirect()->route('vendor1.all')->with([
                    'message' => 'Vendor deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
