<?php

namespace App\Http\Controllers;

use DB;
use Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\HrmEmployeeBenevolentFoundsetting;
use App\HrmEmployeeBenevolentFound;

class hrmBenevolentFundSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $Benevolent_fund = HrmEmployeeBenevolentFoundsetting::latest()->first();

      activity('List')->log('Benevolent Fund List ');

      return view('hrm.BenevolentFound.benevolent-fund' ,compact('Benevolent_fund') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

      activity('Create')->log('Create Benevolent Fund');

        return view('hrm.BenevolentFound.add');
    }

    /*bf update Status*/

    public function updateStatus(Request $request)
    {

      $id = $request->id;

      $status = $request->status;

      $employee_bf_status = HrmEmployeeBenevolentFound::where('employ_id',$id)->update([
                                                                                'status' => $status          

      ]);

        activity('Update Status')->log('Update Status Benevolent Fund');

        return redirect()->route('employee-vouchers')->with('success' , 'Benevolent Found Recevid Successfully!');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

         $validator = Validator::make($request->all(), [
                    'b_fund' => 'required',
                    
        ]);


       if ($validator->fails()) {
            return redirect('hrm.BenevolentFound.add')
                            ->withErrors($validator)
                            ->withInput();
        }

DB::beginTransaction();

   try {

         $bf = HrmEmployeeBenevolentFoundsetting::create([
                    'bf_fund' => $request->b_fund,      
                     
          ]);

        
           activity('Store')->log('Store Benevolent Fund');

           DB::commit();
           return redirect()->route('benevolent-fund.show')->with('success' , 'Benevolent Fund Added Successfully!');
      

      } 
        catch (\Exception $e) 
      {
       DB::rollback();
      return redirect()->route('hrm.BenevolentFound.add')->with('success' , 'Something went wrong.');
      }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Benevolent_fund = HrmEmployeeBenevolentFoundsetting::where('id', $id)->first();

        activity('Edit')->log('Edit Benevolent Fund');

        return view('hrm.BenevolentFound.edit', compact('Benevolent_fund'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
                    'b_fund' => 'required',
                    
        ]);


       if ($validator->fails()) {
            return redirect('hrm.BenevolentFound.add')
                            ->withErrors($validator)
                            ->withInput();
        }

DB::beginTransaction();

   try {

         $bf = HrmEmployeeBenevolentFoundsetting::where('id',$id)->update([
                    'bf_fund' => $request->b_fund,      
                     
          ]);

         
           activity('Update')->log('Update Benevolent Fund');

           DB::commit();
           return redirect()->route('benevolent-fund.show')->with('success' , 'Benevolent Fund Updated Successfully!');
      

      } 
        catch (\Exception $e) 
      {
       DB::rollback();
      return redirect()->route('benevolent-fund.edit')->with('success' , 'Something went wrong.');
      }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $findBf =HrmEmployeeBenevolentFoundsetting::find($id);

           $findBf->delete();

           activity('Delete')->log('Delete Benevolent Fund');

           return redirect()->route('benevolent-fund.show')->with('success' , 'Benevolent Fund Removed Successfully!');
    }
}
