<?php

namespace App\Http\Controllers;

use DB;
use Session;
use Illuminate\Http\Request;
use App\HrmEmployeeDesignation;
use Illuminate\Support\Facades\Validator;

class hrmEmployeeDesignationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $DesignationList = HrmEmployeeDesignation::orderBy('id', 'DESC')->get();

      activity('List')->log('Designation List ');

      return view('hrm.Designation.designation-list' ,compact('DesignationList') );   
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        activity('Create')->log('Designation ');

        return view('hrm.Designation.addDesignation');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:hrm_employee_designations,name',
                    
        ]);


       if ($validator->fails()) {
            return redirect('/designation/add-designation')
                            ->withErrors($validator)
                            ->withInput();
        }

DB::beginTransaction();

   try {

         $designation = HrmEmployeeDesignation::create([
                    'name' => $request->name,
                     
                     
          ]);

            activity('Store')->log('Store Designation');
        
           DB::commit();
           return redirect()->route('designation.list')->with('success' , 'Designation Added Successfully!');
      

      } 
        catch (\Exception $e) 
      {
       DB::rollback();
      return redirect()->route('designation.add')->with('success' , 'Something went wrong.');
      }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       
       $finddesignation =HrmEmployeeDesignation::find($id);

       activity('Edit')->log('Edit Designation');
      
       return view('hrm.Designation.edit-designation' ,compact('finddesignation') );
    

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    
        ]);


       if ($validator->fails()) {
            return redirect('/designation/add-designation')
                            ->withErrors($validator)
                            ->withInput();
        }

DB::beginTransaction();

   try {

         $department = HrmEmployeeDesignation::where('id',$id)->update([
                    'name' => $request->name,      
                     
          ]);

         
          activity('Update')->log('Update Designation');

           DB::commit();
           return redirect()->route('designation.list')->with('success' , 'Designation Updated Successfully!');
      

      } 
        catch (\Exception $e) 
      {
       DB::rollback();
      return redirect()->route('designation.edit')->with('success' , 'Something went wrong.');
      }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
           $finddesignation =HrmEmployeeDesignation::find($id);

           $finddesignation->delete();

           activity('Delete')->log('Delete Designation');
           return redirect()->route('designation.list')->with('success' , 'Designation Removed Successfully!');
    }
}
