<?php

namespace App\Http\Controllers;
use DB;
use storage;
use Session;
use App\User;
use App\Role;
use App\City;
use App\Country;
use App\HrmSetting;
use Carbon\Carbon;
use App\Department;
use App\HrmEmployee;
use App\HrmAttendance;
use App\HrmCompanyDetail;
use App\HrmEmployeeSalary;
use App\HrmEmployeeDocument;
use Illuminate\Http\Request;
use App\HrmBankAccountDetail;
use App\HrmEmployeeDeduction;
use App\HrmEmployeeTotalSalary;
use App\HrmEmployeeDesignation;
use App\HrmEmployeeBenevolentFound;
use Illuminate\Support\Facades\Auth;
use App\HrmEmployeeEarningDeduction;
use App\HrmEmployeeAttendanceSchedual;
use Illuminate\Support\Facades\Validator;
use App\HrmEmployeeMonthlyEarningDeduction;
class hrmReportController extends Controller
{
    /**
     * Display employee list Report.
     *
     * @return \Illuminate\Http\Response
     */
    public function employeeListReport()
    {

       $HrmEmployees =HrmEmployee::with(['companyDetail'])->orderBy('id','DESC')->get();
      
       $HrmEmployees =json_decode(json_encode($HrmEmployees));

       activity('List')->log('Employees List Report');

       return view('report.hrm-employee-list-report', compact('HrmEmployees')); 
    }

    /**
     * Show Monthwise tax Report of Employee .
     *
     * @return \Illuminate\Http\Response
     */
    public function taxReport(Request $request)
    {   
        $month = Carbon::now()->month;
        $year = Carbon::now()->year;
        $employee = $request->employee_id;


        if ($request->month)
        {
        $month = $request->month;
        }

        if ($request->year)
        {
        $year = $request->year;
        }

        $total_monthly_tax =  HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->sum('tax');

        $hrmemployees_salaries = HrmEmployee::with(['employeeEarningDeduction', 'companyDetail']);

        $curent_year = $year;


        if (!empty($employee))
        {
        $hrmemployees_salaries = $hrmemployees_salaries->where('id' , $employee);
        }


        $hrmemployees_salaries =$hrmemployees_salaries->get();

        activity('Tax')->log('Employees Tax Report');

        return view('report.hrm-employees-tax-report', compact('hrmemployees_salaries','month','curent_year','total_monthly_tax'));
    }

    /*employee salary report monthwise*/

    public function salaryDetailsReport(Request $request)
    {
      
        $month = Carbon::now()->month;
        $year = Carbon::now()->year;
        $employee = $request->employee_id;

        if ($request->month)
        {
         $month = $request->month;
        }

        if ($request->year)
        {
         $year = $request->year;
        }
 
         $all_employee_salary = HrmEmployeeMonthlyEarningDeduction::where([['month', $month],['year', $year],['is_approved', 1]])->groupBy(['employ_id','month' , 'year'])->get();


        $total_monthly_earning = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 1);


        $total_monthly_deduction = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 0);

        $total_monthly_tax =  HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->sum('tax');


        $hrmemployees_salaries = HrmEmployee::with(['employeeEarningDeduction', 'companyDetail']);

        $curent_year = $year;


        if (!empty($employee))
        {
        $total_monthly_earning = $total_monthly_earning->where('employ_id' , $employee);
        $total_monthly_deduction = $total_monthly_deduction->where('employ_id' , $employee);
        $hrmemployees_salaries = $hrmemployees_salaries->where('id' , $employee);
        }

        $total_monthly_earning = $total_monthly_earning->sum('amount');
        $total_monthly_deduction = $total_monthly_deduction->sum('amount');
        $hrmemployees_salaries =$hrmemployees_salaries->get();


        activity('Details')->log('Employees Salary Details Report');

        return view('report.hrm-employees-monthly-salary-report', compact('hrmemployees_salaries', 'month', 'curent_year', 'total_monthly_earning', 'total_monthly_deduction','total_monthly_tax','all_employee_salary'));
    }

    /*employee benevolent fund report */

    public function benevolentFundReport(Request $request)
    {
        $month = Carbon::now()->month;
        $year = Carbon::now()->year;

        if ($request->month)
        {
        $month = $request->month;
        }

        if ($request->year)
        {
        $year = $request->year;
        }
        
        $curent_year = $year;

        $employees_benevolent_funds =HrmEmployee::with(['benevolentFund'])->orderBy('id','DESC')->get();
        
        $employees_benevolent_funds =json_decode(json_encode($employees_benevolent_funds));


// echo "<pre>";
// print_r( $employees_benevolent_funds);
// die;
        activity('Benevolent Fund')->log('Benevolent Fund Report');

        return view('report.hrm-employee-benevolent-fund-report', compact('employees_benevolent_funds', 'month', 'year','curent_year'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
