<?php

namespace App\Http\Middleware;

use App\MultiProject;
use Zizaco\Entrust\Middleware\EntrustRole;

use Illuminate\Support\Facades\Auth;

use Closure;

class CustomEntrustRoleMiddleware extends  EntrustRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $roles, $multiProjectId=null)

	{
        
		if (!is_array($roles)) {
			$roles = explode(self::DELIMITER, $roles);
		}
      
    //   $mproject=  MultiProject::where('name','like',$multiProjectId)->first();
    $mproject=  MultiProject::where('name','like','Super Admin')->first();
    
      if(empty($mproject)){
        abort(403);
      }
      $multiProjectId = $mproject->id;
      $user = Auth::user();
        $roles = $user
        ->roles()
        ->whereIn('name', $roles)
           ->where('name', 'like','admin')
        ->whereHas('projects', function ($query) use ($multiProjectId) {
            $query->where('multi_project_id', $multiProjectId);
        })
        ->get();
 
   
		if ($this->auth->guest() || (sizeof($roles) == 0)) {
            abort(403);
		}
         
        
      

		return $next($request);
	}
}
