<?php

namespace App\Imports;

use App\HrmAttendance;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Carbon\Carbon;

class ImportAttendance implements ToModel,WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new HrmAttendance([

            'employ_id'      => $row['employ_id'],
            'present_absent' => $row['present_absent'],
            'date'           => \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row[                'date']),
            'user_id'        => $row['user_id'],
            'checkin'        => \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row[                'checkin']),
            'checkout'       => \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject( $row                ['checkout']),
            'status'         => $row['status'],
            'leave_type'     => $row['leave_type'],
        ]);
    }
}
