<?php

namespace App\Imports;

use App\DirectBallotingMapDetail;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithProgressBar;
use Livewire\Component;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Events\BeforeImport;
use Maatwebsite\Excel\Events\AfterImport;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;

use Maatwebsite\Excel\Imports\HeadingRowFormatter;
use App\UnitSize;
use App\DirectBallonMapDetailCategory;

 

use App\Events\ImportProgressUpdated;
use App\UnitBlock;
use App\UnitCategory;
use App\UnitFloor;
use App\UnitType;
use App\UnitFloorSize;
use App\BallonMapDetailCategory;

class ImportDirectMapFileData implements ToModel,WithStartRow,WithHeadingRow, WithEvents
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    use Importable, WithFileUploads, RegistersEventListeners;
    private  $balloting_map_id;
  public $rowCount = 0;
  public $totalRows = 0;
  public $progress = 0;
  
    function __construct($id,$rows){
         $this->balloting_map_id = $id;
         $this->totalRows=$rows;
         HeadingRowFormatter::default('none');
        
    }    public function model(array $row)
    {
        $this->rowCount++;

        
        
        $this->progress++;
        
       
        session(['progress' => ($this->progress  / $this->totalRows) * 100]);
        

       $size_val= $row["Category(Area)"];
       if($size_val != null){
      $unit_size= UnitSize::where('name', $size_val)->first();
        if (empty($unit_size)) {
            $unit_size=   new UnitSize;
            $unit_size->name = $size_val;
            $unit_size->status = 1;
            $unit_size->save();

        }
            $unit_size = $unit_size->id;
    }
    else {
        $unit_size='';
    }
  
        $type_val= $row["Type"];
        if($type_val != null){
        $unit_type= UnitType::where('name','like', $type_val)->first();
        
          if (empty($unit_type)) {
              $unit_type =   new UnitType;
              $unit_type->name = $type_val;
              $unit_type->status = 1;
              $unit_type->save();
  
          }
          
            $unit_type=$unit_type->id;
        } else {
            $unit_type='';
        }
       $sector_val=   $row["Sector"];
       if($sector_val != null){
   $unit_block=UnitBlock::where('name', 'like', $sector_val)->where('is_deleted', 0)->first();
        if (empty($unit_block)) {
            $unit_block = new UnitBlock;
            $unit_block->name = $sector_val;

            $unit_block->save();
        }
            $unit_block = $unit_block->id;
          

    }else {
        $unit_block='';
    }
  
        $road_val = $row["Street No"];
        if($road_val != null){
        $unit_floor=     UnitFloor::where('name', 'like', $road_val)->where('is_deleted', 0)->first();
        if (empty($unit_floor)) {
            $unit_floor = new UnitFloor;
            $unit_floor->name = $road_val;
                $unit_floor->unit_block_id = $unit_block;
            $unit_floor->save();
        }
        $unit_floor=    $unit_floor->id;
        if(!empty($unit_block) && !empty($unit_floor)){
           $unit_floor_check=    UnitFloor::where('unit_block_id',$unit_block)->where('id',$unit_floor)->first();
          if(empty($unit_floor_check)){
            $unit_floor_new = new UnitFloor;
            $unit_floor_new->name = $road_val;
            $unit_floor_new->unit_block_id = $unit_block;
            $unit_floor_new->save();
            $unit_floor=    $unit_floor_new->id;
          }     
    }

    }
    else {
        $unit_floor='';
    }
    
        $category_array = [];
       $category_string='';
        $result = explode('+',  $row["Feature"]);
        if(!empty( $result)){
        foreach ($result as $r) {
          $unit_category=  UnitCategory::where('name', 'like', $r)->where('is_deleted',0)->first();
            if (empty($unit_category)) {
                $unit_category=   new  UnitCategory;
                $unit_category->name = $r;
                $unit_category->percent = 0;
                $unit_category->save();
            }
            $category_string = $unit_category->id.'+'.$category_string;
            $category_array[] = $unit_category->id;
        }
    }

    if(!empty($unit_floor) && !empty($unit_type)){
     UnitFloorSize::create(['unit_floor_id'=>$unit_floor,'unit_type_id'=>$unit_type]);
    }
    $balloting_detail=    new DirectBallotingMapDetail;
    $balloting_detail->direct_balloting_map_file_id= $this->balloting_map_id;
    $balloting_detail->sr_no=$row['Sr No'];
    $balloting_detail->plot_no =$row["Plot No"] ;
    $balloting_detail->area=$row["Category(Area)"];
    $balloting_detail->feature=$row["Feature"];
    $balloting_detail->exact_odd=$row["Exact/Odd"];
    $balloting_detail->sector=$row["Sector"];
    $balloting_detail->street=$row["Street No"];
    $balloting_detail->type=$row["Type"];
    $balloting_detail->road_category=$row["Road Category"];
    $balloting_detail->cnic=$row["Cnic"];
    $balloting_detail->membershipno=$row["MemberShip No"];
    $balloting_detail->unit_size_id= $unit_size;
    $balloting_detail->unit_type_id= $unit_type;
    $balloting_detail->unit_block_id=$unit_block;
    $balloting_detail->unit_floor_id=$unit_floor;
    $balloting_detail->save();
    if(!empty($category_array)){
        foreach($category_array as $arr){
       $ballon_category=  new   DirectBallonMapDetailCategory;
                $ballon_category->ballon_map_detail_id = $balloting_detail->id;
       $ballon_category->category_id = $arr;
            $ballon_category->save();
        }

    }
    


        
         return $balloting_detail;
        // return new DirectBallotingMapDetail([
        //     //
        // ]);
    }
    public function startRow(): int
    {
        // return the number of the row where the import should start (in this case, the second row)
        return 2;
    }
    public function getRowCount(): int
    {
        return $this->rowCount;
    }

    public function getTotalRows(): int
    {
        return $this->totalRows;
    }
}
