<?php

namespace App\Imports;

use App\BallotingMapDetail;
use App\Http\Livewire\ImportExcel;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithProgressBar;
use Livewire\Component;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Events\BeforeImport;
use Maatwebsite\Excel\Events\AfterImport;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;

use Maatwebsite\Excel\Imports\HeadingRowFormatter;
use App\UnitSize;

 

use App\Events\ImportProgressUpdated;
use App\UnitBlock;
use App\UnitCategory;
use App\UnitFloor;
use App\UnitType;
use App\UnitFloorSize;
use App\BallonMapDetailCategory;

class ImportMapFileData  implements ToModel,WithStartRow,WithHeadingRow, WithEvents
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    use Importable, WithFileUploads, RegistersEventListeners;
    private  $balloting_map_id;
  public $rowCount = 0;
  public $totalRows = 0;
  public $progress = 0;
  
    function __construct($id,$rows){
         $this->balloting_map_id = $id;
         $this->totalRows=$rows;
         HeadingRowFormatter::default('none');
        
    }
  

    // public static function beforeImport(BeforeImport $event)
    // {
        
    //     $total_rows = $event->getReader()->getTotalRows();
    //     $filePath = public_path('file.xlsx');
    //    $reader = Excel::selectSheets('Sheet1')->load($filePath);
    //      $totalRows = $reader->getTotalRows();
    //     session()->put('total_rows', $total_rows);
    // }

    // public static function afterImport(AfterImport $event)
    // {
    //     session()->forget('total_rows');
    // }
    public function model(array $row)
    {
        // Increment the row count
        $this->rowCount++;

        
        
        $this->progress++;
        
       
        session(['progress' => ($this->progress  / $this->totalRows) * 100]);
        

       $size_val= $row["Category(Area)"];
       if($size_val != null){
      $unit_size= UnitSize::where('name', $size_val)->first();
        if (empty($unit_size)) {
            $unit_size=   new UnitSize;
            $unit_size->name = $size_val;
            $unit_size->status = 1;
            $unit_size->save();

        }
            $unit_size = $unit_size->id;
    }
    else {
        $unit_size='';
    }
        $type_val= $row["Type"];
        if($type_val != null){
        $unit_type= UnitType::where('name','like', $type_val)->first();
          if (empty($unit_size)) {
              $unit_type =   new UnitType;
              $unit_type->name = $type_val;
              $unit_type->status = 1;
              $unit_type->save();
  
          }
            $unit_type=$unit_type->id;
        } else {
            $unit_type='';
        }
       $sector_val=   $row["Sector"];
       if($sector_val != null){
   $unit_block=UnitBlock::where('name', 'like', $sector_val)->where('is_deleted', 0)->first();
        if (empty($unit_block)) {
            $unit_block = new UnitBlock;
            $unit_block->name = $sector_val;

            $unit_block->save();
        }
            $unit_block = $unit_block->id;
    }else {
        $unit_block='';
    }
        $road_val = $row["Street No"];
        if($road_val != null){
        $unit_floor=     UnitFloor::where('name', 'like', $road_val)->where('is_deleted', 0)->first();
        if (empty($unit_floor)) {
            $unit_floor = new UnitFloor;
            $unit_floor->name = $road_val;
                $unit_floor->unit_block_id = $unit_block;
            $unit_floor->save();
        }
        $unit_floor=    $unit_floor->id;
    }
    else {
        $unit_floor='';
    }

        $category_array = [];
       $category_string='';
        $result = explode('+',  $row["Feature"]);
        if(!empty( $result)){
        foreach ($result as $r) {
          $unit_category=  UnitCategory::where('name', 'like', $r)->where('is_deleted',0)->first();
            if (empty($unit_category)) {
                $unit_category=   new  UnitCategory;
                $unit_category->name = $r;
                $unit_category->percent = 0;
                $unit_category->save();
            }
            $category_string = $unit_category->id.'+'.$category_string;
            $category_array[] = $unit_category->id;
        }
    }

    if(!empty($unit_floor) && !empty($unit_type)){
     UnitFloorSize::create(['unit_floor_id'=>$unit_floor,'unit_type_id'=>$unit_type]);
    }

    
        // $row["Road Category"];
        // $row["Sector"];
        // $row["Feature"];


    $balloting_detail=    new BallotingMapDetail;
    $balloting_detail->balloting_map_file_id= $this->balloting_map_id;
    $balloting_detail->sr_no=$row['Sr No'];
    $balloting_detail->plot_no =$row["Plot No"] ;
    $balloting_detail->area=$row["Category(Area)"];
    $balloting_detail->feature=$row["Feature"];
    $balloting_detail->exact_odd=$row["Exact/Odd"];
    $balloting_detail->sector=$row["Sector"];
    $balloting_detail->street=$row["Street No"];
    $balloting_detail->type=$row["Type"];
    $balloting_detail->road_category=$row["Road Category"];
    $balloting_detail->unit_size_id= $unit_size;
    $balloting_detail->unit_type_id= $unit_type;
    $balloting_detail->unit_block_id=$unit_block;
    $balloting_detail->unit_floor_id=$unit_floor;
    $balloting_detail->save();
    if(!empty($category_array)){
        foreach($category_array as $arr){
       $ballon_category=  new   BallonMapDetailCategory;
                $ballon_category->ballon_map_detail_id = $balloting_detail->id;
       $ballon_category->category_id = $arr;
            $ballon_category->save();
        }

    }
    
//   $balloting_detail=     new BallotingMapDetail([
//             'balloting_map_file_id'=> $this->balloting_map_id,
//             'sr_no'=>$row['Sr No'],
//             'plot_no'=>$row["Plot No"],
//             'area'=>$row["Category(Area)"],
//             'feature'=>$row["Feature"],
//             'exact_odd'=>$row["Exact/Odd"],
//             'sector'=>$row["Sector"],
//             'street'=> $row["Street No"],
//             'type'=> $row["Type"],
//             'road_category'=>$row["Road Category"],
//             'unit_size_id'=> $unit_size,
//             'unit_type_id'=> $unit_type,
//             'unit_block_id'=>$unit_block,
//             'unit_floor_id'=>$unit_floor,
//             'unit_category_ids'=>$category_string

 
 
//          ]);

        
         return $balloting_detail;
        
    }
    public function startRow(): int
    {
        // return the number of the row where the import should start (in this case, the second row)
        return 2;
    }
    public function getRowCount(): int
    {
        return $this->rowCount;
    }

    public function getTotalRows(): int
    {
        return $this->totalRows;
    }

    // public function registerEvents(): array
    // {
    //     // return [
    //     //     // Count the total number of rows in the file
    //     //     \Maatwebsite\Excel\Excel::beforeImport => function (\Maatwebsite\Excel\Events\BeforeImport $event) {
    //     //         $this->totalRows = $event->getReader()->getTotalRows();
    //     //     }
    //     // ];
    //     return [
    //         // Count the total number of rows in the file
    //         \Maatwebsite\Excel\Excel::beforeImport => function (\Maatwebsite\Excel\Events\BeforeImport $event) {
    //             $this->totalRows = $event->getReader()->getTotalRows();
    //         },
            
    //         // Update the progress bar
    //         \Maatwebsite\Excel\Events\ImportFailed::class => function () {
    //             $this->progress(0);
    //         },
    //         \Maatwebsite\Excel\Events\ImportStarted::class => function () {
    //             $this->progress(0);
    //         },
    //         \Maatwebsite\Excel\Events\ImportFinished::class => function () {
    //             $this->progress(100);
    //         },
    //         \Maatwebsite\Excel\Events\AfterSheet::class => function (\Maatwebsite\Excel\Events\AfterSheet $event) {
    //             $this->progress(($event->sheet->getIndex() / $event->totalSheets) * 100);
    //         }
    //     ];
    // }
    // public function getTotalRows(): int
    // {
    //     // Open the file and count the rows (excluding the header row)
    //     $file = fopen($this->file, 'r');
    //     $row_count = count(file($this->file)) - 1;
    //     fclose($file);

    //     return $row_count;
    // }
    // public function getRowCount(): int
    // {
    //     $this->row_count = $this->row_count ?? 1;

    //     $this->row_count++;

    //     $this->import_progress = min(100, round(($this->row_count / $this->getTotalRows()) * 100));

    //     return $this->row_count;
    // }

    // public function getTotalRows()
    // {
    //     return $this->getDelegate()->getTotalRows();
    // }
}
