<?php

namespace App\Imports;

use App\BallotingMapDetail;
use App\Http\Livewire\ImportExcel;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithProgressBar;
use Livewire\Component;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Events\BeforeImport;
use Maatwebsite\Excel\Events\AfterImport;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;

use Maatwebsite\Excel\Imports\HeadingRowFormatter;
use App\UnitSize;

 

use App\Events\ImportProgressUpdated;

class ImportMapFileData  implements ToModel,WithStartRow,WithHeadingRow, WithEvents
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    use Importable, WithFileUploads, RegistersEventListeners;
    private  $balloting_map_id;
  public $rowCount = 0;
  public $totalRows = 0;
  public $progress = 0;
  
    function __construct($id,$rows){
         $this->balloting_map_id = $id;
         $this->totalRows=$rows;
         HeadingRowFormatter::default('none');
        
    }
  

    // public static function beforeImport(BeforeImport $event)
    // {
        
    //     $total_rows = $event->getReader()->getTotalRows();
    //     $filePath = public_path('file.xlsx');
    //    $reader = Excel::selectSheets('Sheet1')->load($filePath);
    //      $totalRows = $reader->getTotalRows();
    //     session()->put('total_rows', $total_rows);
    // }

    // public static function afterImport(AfterImport $event)
    // {
    //     session()->forget('total_rows');
    // }
    public function model(array $row)
    {
        // Increment the row count
        $this->rowCount++;

        
        
        $this->progress++;
        
       
        session(['progress' => ($this->progress  / $this->totalRows) * 100]);
        

       $size_val= $row["Category(Area)"];
      $unit_size= UnitSize::where('name', $size_val)->first();
        if (empty($unit_size)) {
            $unit_size=   new UnitSize;
            $unit_size->name = $size_val;
            $unit_size->status = 1;
            $unit_size->save();

        }
        
     return   new BallotingMapDetail([
            'balloting_map_file_id'=> $this->balloting_map_id,
            'sr_no'=>$row['Sr No'],
            'plot_no'=>$row["Plot No"],
            'area'=>$row["Category(Area)"],
            'feature'=>$row["Feature"],
            'exact_odd'=>$row["Exact/Odd"],
            'sector'=>$row["Sector"],
            'road_category'=>$row["Road Category"],
            'unit_size_id'=> $unit_size->id
 
 
         ]);
    }
    public function startRow(): int
    {
        // return the number of the row where the import should start (in this case, the second row)
        return 2;
    }
    public function getRowCount(): int
    {
        return $this->rowCount;
    }

    public function getTotalRows(): int
    {
        return $this->totalRows;
    }

    // public function registerEvents(): array
    // {
    //     // return [
    //     //     // Count the total number of rows in the file
    //     //     \Maatwebsite\Excel\Excel::beforeImport => function (\Maatwebsite\Excel\Events\BeforeImport $event) {
    //     //         $this->totalRows = $event->getReader()->getTotalRows();
    //     //     }
    //     // ];
    //     return [
    //         // Count the total number of rows in the file
    //         \Maatwebsite\Excel\Excel::beforeImport => function (\Maatwebsite\Excel\Events\BeforeImport $event) {
    //             $this->totalRows = $event->getReader()->getTotalRows();
    //         },
            
    //         // Update the progress bar
    //         \Maatwebsite\Excel\Events\ImportFailed::class => function () {
    //             $this->progress(0);
    //         },
    //         \Maatwebsite\Excel\Events\ImportStarted::class => function () {
    //             $this->progress(0);
    //         },
    //         \Maatwebsite\Excel\Events\ImportFinished::class => function () {
    //             $this->progress(100);
    //         },
    //         \Maatwebsite\Excel\Events\AfterSheet::class => function (\Maatwebsite\Excel\Events\AfterSheet $event) {
    //             $this->progress(($event->sheet->getIndex() / $event->totalSheets) * 100);
    //         }
    //     ];
    // }
    // public function getTotalRows(): int
    // {
    //     // Open the file and count the rows (excluding the header row)
    //     $file = fopen($this->file, 'r');
    //     $row_count = count(file($this->file)) - 1;
    //     fclose($file);

    //     return $row_count;
    // }
    // public function getRowCount(): int
    // {
    //     $this->row_count = $this->row_count ?? 1;

    //     $this->row_count++;

    //     $this->import_progress = min(100, round(($this->row_count / $this->getTotalRows()) * 100));

    //     return $this->row_count;
    // }

    // public function getTotalRows()
    // {
    //     return $this->getDelegate()->getTotalRows();
    // }
}
