<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;

class InstallmentPlan extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    
    const manual = 1;
    const percentage = 2;
    protected $fillable = [
       'unit_type','unit_size','cost_amount','down_payment','confirmation_fee','unit_belting_fee','possession_fee','installment','total_months','status','six_installment'
    ];
    
    public function unitType() {
        return $this->belongsTo('\App\ProductType','unit_type');
    }
    
    public function unitSize() {
        return $this->belongsTo('\App\ProductSize','unit_size');
    }
    
    public function createInstallmentPlan($request) {
     
        
        if($request->schedule_type == InstallmentPlan::percentage) {
            $plan = InstallmentPlan::create(Input::except('schedule_type'));
        }
        else {
            if($request->unit_type == CustomerProperty::residential) {
                $plan = InstallmentPlan::create(['unit_type'=>$request->unit_type,'unit_size'=>$request->unit_size,
                'cost_amount'=>$request->cost_amount,'down_payment'=>($request->down_payment * 100 / $request->cost_amount),
                    'confirmation_fee'=>($request->confirmation_fee * 100 / $request->cost_amount),'unit_belting_fee'=>
                ($request->unit_belting_fee * 100 / $request->cost_amount),'six_installment'=>
                    (($request->six_installment * 8 )* 100 / $request->cost_amount),'possession_fee'
                    =>($request->possession_fee * 100 / $request->cost_amount),'installment'=>
                    (($request->installment * $request->total_months) * 100 / $request->cost_amount),
                    'total_months'=>$request->total_months,'status'=>$request->status]); 
            }
            else{
                 $plan = InstallmentPlan::create(['unit_type'=>$request->unit_type,'unit_size'=>$request->unit_size,
                'cost_amount'=>$request->cost_amount,'down_payment'=>($request->down_payment * 100 / $request->cost_amount),
                    'confirmation_fee'=>($request->confirmation_fee * 100 / $request->cost_amount),'unit_belting_fee'=>
                ($request->unit_belting_fee * 100 / $request->cost_amount),'six_installment'=>
                    (($request->six_installment * 8 )* 100 / $request->cost_amount),'possession_fee'
                    =>($request->possession_fee * 100 / $request->cost_amount),'installment'=>
                    (($request->installment * ($request->total_months - 8)) * 100 / $request->cost_amount),
                    'total_months'=>$request->total_months,'status'=>$request->status]); 
            }
           
        }
        return $plan;
    }
    
    public function updateInstallmentPlan($request) {
        
        if($request->schedule_type == InstallmentPlan::percentage) {
            $plan = InstallmentPlan::where('id',$request->id)->update(Input::except('_token','schedule_type'));
        }
        else {
            if($request->unit_type == CustomerProperty::residential) {
                $plan = InstallmentPlan::where('id',$request->id)->update(['unit_type'=>$request->unit_type,'unit_size'=>$request->unit_size,
                'cost_amount'=>$request->cost_amount,'down_payment'=>($request->down_payment * 100 / $request->cost_amount),
                    'confirmation_fee'=>($request->confirmation_fee * 100 / $request->cost_amount),'unit_belting_fee'=>
                ($request->unit_belting_fee * 100 / $request->cost_amount),'six_installment'=>
                    (($request->six_installment * 8 )* 100 / $request->cost_amount),'possession_fee'
                    =>($request->possession_fee * 100 / $request->cost_amount),'installment'=>
                    (($request->installment * $request->total_months) * 100 / $request->cost_amount),
                    'total_months'=>$request->total_months,'status'=>$request->status]); 
            }
            else{
                 $plan = InstallmentPlan::where('id',$request->id)->update(['unit_type'=>$request->unit_type,'unit_size'=>$request->unit_size,
                'cost_amount'=>$request->cost_amount,'down_payment'=>($request->down_payment * 100 / $request->cost_amount),
                    'confirmation_fee'=>($request->confirmation_fee * 100 / $request->cost_amount),'unit_belting_fee'=>
                ($request->unit_belting_fee * 100 / $request->cost_amount),'six_installment'=>
                    (($request->six_installment * 8 )* 100 / $request->cost_amount),'possession_fee'
                    =>($request->possession_fee * 100 / $request->cost_amount),'installment'=>
                    (($request->installment * ($request->total_months - 8)) * 100 / $request->cost_amount),
                    'total_months'=>$request->total_months,'status'=>$request->status]); 
            }
        }
    }
}
