<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class Inventory extends Model
{
   
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'multi_project_id', 'unit_type_id','unit_size_id','unit_number','rate_marla','inventory_type','total_price','status','type','description','extra_amount_description','extra_amount','unit_category_id','unit_floor_id','name','phone_number','email','cnic','is_deleted','area','token_amount','pricelist_id','total_size','old_unit_number'
    ];

    //Inventory Status
    const open = 1;
    const hold_client = 3;
    const hold_company = 4;
    const sold = 2;
    const token_hold = 5;
    const temp_hold = 6;

    const block = 7;

    const package_open_file = 8;

    const package_open_file_refunded = 9;
    
    
    
    //Inventory Type
    const allocated = 0;
    const unallocated = 1;
  

    public function size() {
        return $this->belongsTo('App\UnitSize','unit_size_id')->select('id','name');
    }

    public function category() {
        return $this->belongsTo('App\UnitCategory','unit_category_id')->select('id','name');
    }
    public function type() {
        return $this->belongsTo('App\UnitType','unit_type_id')->select('id','name');
    }

    public function floor() {
        return $this->belongsTo('App\UnitFloor','unit_floor_id')->with(['unitFloors','unitBlock'])->select('*');
    }

    public function categories() {
        return $this->hasMany('App\InventoryCategory')->with('category');
    }
    
    public function property() {
        return $this->hasOne('\App\CustomerProperty','inventory_id')->with('customer','saleBy');
    }

    public function project() {
        return $this->belongsTo('\App\AccountClass');
    }

    public function priceList() {
        return $this->belongsTo('\App\PriceList','pricelist_id','id');
    }

  public function customer_property() {
        return $this->hasOne('\App\CustomerProperty','inventory_id')->where('status' , '!=' , CustomerProperty::cancel)->with('customer');
    }
    
    public function oldNames() {
        return $this->hasMany('App\InventoryOldName');
    }


    public function dealerPackageOpenFileUnit(){
        return $this->hasOne('\App\OpenFileDealerInfo','invertory_id');
    }





    public function getAllInventories() {
        return Inventory::where([['is_deleted',false]])
        ->select('inventories.unit_number','inventories.id','inventories.status','inventories.total_price','inventories.unit_size_id','inventories.multi_project_id')
        ->paginate(25);
    }
    public function getUpdateAllInventories() {
        return Inventory::where([['is_deleted',false]])
        ->select('inventories.unit_number','inventories.id','inventories.status','inventories.total_price','inventories.unit_size_id','inventories.multi_project_id')
        ->paginate(25);
    }

    public function getAllOpenInventories() {
        return Inventory::where([['is_deleted',false]])->where('status',Inventory::open)
        ->select('inventories.unit_number','inventories.id','inventories.status','inventories.total_price')
        ->paginate(100);
    }
    public function dealer() {
        return $this->belongsTo('\App\Dealer','dealer_id');
    }
    public function  multiProject() {
        return $this->belongsTo('\App\MultiProject','multi_project_id','id');
    }


    public function addNewInventory($request,$projecttype) {

        if ($projecttype == ProjectType::high_rise) {
            
            $word = "create";
            
            if (strpos($request->unit_size_id, $word) !== false) {
              
            
              $new_str = str_replace($word, "", $request->unit_size_id);
              $unit_size= new UnitSize;
                $unit_size->name = $new_str;
                $unit_size->status = 1;
                $unit_size->save();

                $inventory = Inventory::create(['unit_size_id' => $unit_size->id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'area'=>$request->area,'inventory_type'=>$request->type,'pricelist_id'=>$request->price_list_id,'total_size'=>$request->size,'multi_project_id'=>$request->multipro_id]);

            }
            else{
                $inventory = Inventory::create(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id' => $request->unit_type_id, 'area' => $request->area, 'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,'multi_project_id'=>$request->multipro_id]);
            }

        } else {
            $inventory = Inventory::create(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id' => $request->unit_type_id, 'area' => $request->area, 'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,'multi_project_id'=>$request->multipro_id]);
        }
        if($request->unit_category_id) {

        for($i =0 ;$i<count($request->unit_category_id) ;$i++) {

            InventoryCategory::create(['inventory_id'=>$inventory->id,'unit_category_id'=>$request->unit_category_id[$i]]);
        }
    }


        return $inventory;
    }

    public function updateInventory($request,$projecttype) {

        $inv = Inventory::where('id',$request->id)->first();
        if ($projecttype == ProjectType::high_rise) {
            
            $word = "create";
            
            if (strpos($request->unit_size_id, $word) !== false) {
              
            
              $new_str = str_replace($word, "", $request->unit_size_id);
              $unit_size= new UnitSize;
                $unit_size->name = $new_str;
                $unit_size->status = 1;
                $unit_size->save();
                if($request->status == Inventory::open  || $request->status ==Inventory::package_open_file) 
                {
                    Inventory::where('id',$request->id)->update(['unit_size_id' => $unit_size->id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'name'=>'','cnic'=>'','email'=>'','phone_number'=>'','token_amount'=>null,'area'=>$request->area,'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,
                    'multi_project_id'=>$request->multipro_id]);    
                }
                else 
                {
                    Inventory::where('id',$request->id)->update(['unit_size_id' => $unit_size->id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'name'=>$request->name,'cnic'=>$request->cnic,'email'=>$request->email,'phone_number'=>$request->phone_number,'dealer_id'=>$request->dealer_id,'area'=>$request->area,'token_amount'=>$request->token_amount,'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size, 'multi_project_id'=>$request->multipro_id]);
                }
            }
            else
            {
                if($request->status == Inventory::open  || $request->status ==Inventory::package_open_file)  
                {
                    Inventory::where('id',$request->id)->update(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'name'=>'','cnic'=>'','email'=>'','phone_number'=>'','token_amount'=>null,'area'=>$request->area,'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,
                    'multi_project_id'=>$request->multipro_id]);
                    
                }
                else 
                {
                    Inventory::where('id',$request->id)->update(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'name'=>$request->name,'cnic'=>$request->cnic,'email'=>$request->email,'phone_number'=>$request->phone_number,'dealer_id'=>$request->dealer_id,'area'=>$request->area,'token_amount'=>$request->token_amount,'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,
                    'multi_project_id'=>$request->multipro_id]);
                }
            }

        } else {
            if($request->status == Inventory::open || $request->status ==Inventory::package_open_file) 
            {
                Inventory::where('id',$request->id)->update(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'name'=>'','cnic'=>'','email'=>'','phone_number'=>'','token_amount'=>null,'area'=>$request->area,'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,
                'multi_project_id'=>$request->multipro_id]);
                
            }
            else 
            {
                Inventory::where('id',$request->id)->update(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'name'=>$request->name,'cnic'=>$request->cnic,'email'=>$request->email,'phone_number'=>$request->phone_number,'dealer_id'=>$request->dealer_id,'area'=>$request->area,'token_amount'=>$request->token_amount,'inventory_type' => $request->type, 'pricelist_id' => $request->price_list_id, 'total_size' => $request->size,
                'multi_project_id'=>$request->multipro_id]);
            }
        }
        //update Inventory
        

        InventoryCategory::where('inventory_id',$request->id)->delete();

        if($request->unit_category_id) {
            for($i =0 ;$i<count($request->unit_category_id) ;$i++) {
                InventoryCategory::create(['inventory_id'=>$request->id,'unit_category_id'=>$request->unit_category_id[$i]]);
            }
        }

        //check name change or not
        if($inv->unit_number != $request->unit_number)
            InventoryOldName::create(['name'=>$inv->unit_number,'inventory_id'=>$inv->id]);

    }

    public function getInfo() {

        $building['total_area'] = DB::table('inventories')->join('unit_sizes','unit_sizes.id','=','inventories.unit_size_id')->select(DB::raw('sum(unit_sizes.name) as total'))->get()[0]->total;

        $building['total_amount'] = Inventory::sum('total_price');

        $building['min_area'] = DB::table('inventories')->join('unit_sizes','unit_sizes.id','=','inventories.unit_size_id')->select(DB::raw('min(unit_sizes.name) as total'))->get()[0]->total;

        $building['max_area'] = DB::table('inventories')->join('unit_sizes','unit_sizes.id','=','inventories.unit_size_id')->select(DB::raw('max(unit_sizes.name) as total'))->get()[0]->total;

        $building['open'] = Inventory::where('status',Inventory::open)->count();

        $building['sold'] = Inventory::where('status',Inventory::sold)->count();

       // $building['hold'] = 0;

        return $building;
    }

    public function getFloorInfo($floor) {

        $building['total_area'] = DB::table('inventories')
        ->where('unit_floor_id',$floor)
        ->join('unit_sizes','unit_sizes.id','=','inventories.unit_size_id')->select(DB::raw('sum(unit_sizes.name) as total'))->get()[0]->total;

        $building['total_amount'] = Inventory::where('unit_floor_id',$floor)->sum('total_price');

        $building['min_unit'] = DB::table('inventories')
        ->where('unit_floor_id',$floor)
        ->join('unit_sizes','unit_sizes.id','=','inventories.unit_size_id')->select(DB::raw('min(unit_sizes.name) as total'))->get()[0]->total;

        $building['max_unit'] = DB::table('inventories')->where('unit_floor_id',$floor)
        ->join('unit_sizes','unit_sizes.id','=','inventories.unit_size_id')->select(DB::raw('max(unit_sizes.name) as total'))->get()[0]->total;

        $building['open'] = Inventory::where('unit_floor_id',$floor)->where('status',Inventory::open)->count();

        $building['sold'] = Inventory::where('unit_floor_id',$floor)->where('status',Inventory::sold)->count();

       // $building['hold'] = 0;

        $data = UnitFloor::where('id',$floor)->first();

        $building['title'] = $data->name;


        return $building;
    }

    public function updateTable($filters,$id=null) {

        
       
        $query = Inventory::where([['is_deleted',false]])
        ->when($id[0] !== 'all', function ($query) use ($id) {
            $query->whereIn('multi_project_id', $id);
        })
        ;

        foreach($filters as $key => $val) 
        {
            if($key == 'status')
                $query = $query->where('status',$val);
            elseif($key == 'unit')
                $query = $query->where('id',$val);
            elseif($key == 'floor')
                $query = $query->whereHas('floor',function($query) use($val){
                    $query->where('id',$val);
                });
            elseif($key == 'size')
                $query = $query->whereHas('size',function($query) use($val){
                    $query->where('id',$val);
                });
            elseif($key == 'inventory_type')
           
                $query->where('inventory_type',$val);
        }
      
        $query->select('inventories.unit_number','inventories.id','inventories.status','inventories.total_price','inventories.multi_project_id');
        $result = $query->get();
     
        return ['allInventories'=>$result];
    }

    public function noc() {
        return $this->hasOne('\App\NOC','unit_number_id');
    }
}
