<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model
{
     
     use SoftDeletes;

     protected $fillable = [
        'item_code',
        'item_name',
        'minqty',
        'maxqty',
        'unit',
        'category_id',
        'created_by',
        'description',
        'quantity',
        'manufacture_id',
        'type',
        'size',
        'risk_type',
    ];

    public function category()
    {
      return $this->belongsTo('App\Category')->withTrashed();
    }

     public function manufacture()
    {
      return $this->belongsTo('App\ItemManufacture' , 'manufacture_id');
    }

   

    public function vendors()
    {
      return $this->belongsToMany('App\PurchaseRequestVendor');
    }

     public function comparativeStatements()
   {
      return $this->hasMany('App\ComparativeStatement' , 'purchase_request_id');
   }

       public function ItemPurchaseRequests()
   {
      return $this->hasMany('App\ItemPurchaseRequest' , 'purchase_request_id');
   }


}
