<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ItemPurchaseRequest extends Model
{
     protected $table = 'item_purchase_request';
     
     protected $fillable = [
        'purchase_request_id',
        'item_id',
        'quantity',
        'price',
        'description',
        'receive_quantity',
        'remaining_quantity'
    ];

    public function purchaseRequest()
    {
      return $this->belongsTo('App\PurchaseRequest');
    }

    public static function getRequestedItems($purchase_request_id=null , $item_id = null )
    {
       return ItemPurchaseRequest::where('purchase_request_id' , $purchase_request_id)->where('item_id' , $item_id)->first();
    }

    

}
