<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ItemRelease extends Model
{
     protected $table = 'item_releasings';

      protected $fillable = [
        'purchase_request_id',
        'mir_id',
        'department_id',
        'releaser_name',
        'releasing_date',
        'receiver_name',
        'releaser_name',
        'returning_name',
        'return_date',
    ];

      public $timestamps = false;

public function scopeWithAndWhereHas($query, $relation, $constraint){
  return $query->whereHas($relation, $constraint)
  ->with([$relation => $constraint]);
  }


    public function project()
    {
      return $this->belongsTo('App\Project');
    }

   public function department()
    {
      return $this->belongsTo('App\Department');
    }

     public function releasingItems()
    {
      return $this->hasMany('App\ItemReleaseData' , 'item_releasing_id');
    }

}
