<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Inventory;
use App\OpenFileDealerInfo;
use App\OpenFilePackage;
use App\PriceList;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use  App\UnitSize;
use App\UnitType;


class AddInventoryForDealerPackage implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
   private $package_id;
    public function __construct($package_id)
    {
        //
        $this->package_id = $package_id;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
      $package_detail =  OpenFilePackage::where('id', $this->package_id)->first();

      $price_list = PriceList::where('id',$package_detail->pricelist_id)->first();


    //   $rand_value=  rand('0000', '9999');

         
        foreach($package_detail->packageDetail as $detail){
          $detail_price=  $price_list->pricedetail->where('unit_type_id')->where('unit_size_id')->first();
            for ($i = 0; $i < sizeof($detail->unit_quantity); $i++) {
                  $unit_number = Str::randomNumber(6, true, 'inventories', 'unit_number');
                  $inventory= new Inventory;
                  $inventory->unit_size_id= $detail->unit_size_id;
                  $inventory->unit_number = $unit_number;
                  $inventory->total_price =   $detail_price->total_price;
                  $inventory->status = Inventory::package_open_file ;
                  $inventory->description = 'Dealer Package Open File ' ;
                  $inventory->extra_amount = 0 ;
                  $inventory->unit_type_id = $detail->unit_type_id; 
                  $inventory->inventory_type =  Inventory::unallocated;
                  $inventory->pricelist_id =$package_detail->pricelist_id;
                  $inventory->save();

                  $openfile_dealer  = new OpenFileDealerInfo;
                  $openfile_dealer->dealer_id;
                  $openfile_dealer->invertory_id= $inventory->id; 
                  $openfile_dealer->issue_date ;
                  $openfile_dealer->valid_until_date;
                $openfile_dealer->save();

                  	 	 	 

            }
            

        }
     

      
 
    //    $inventory = Inventory::create(['unit_size_id' => $request->unit_size_id, 'unit_number' => $request->unit_number, 'unit_floor_id' => $request->unit_floor_id, 'total_price' => $request->net_amount, 'status' => $request->status, 'description' => $request->description, 'extra_amount' => $request->net_amount - $request->total_price, 'unit_type_id'=>$request->unit_type_id,'area'=>$request->area,'inventory_type'=>$request->type,'pricelist_id'=>$request->price_list_id,'total_size'=>$request->size]);

        // new OpenFileDealerInfo;
    }

    // public function validator($unit_number)
    // {
    //     $validator = Validator::make(['unit_number' => $unit_number], [
    //         'unit_number'=>'unique:inventories,unit_number|required|regex:/^[a-zA-Z0-9\s,-.]+$/u',
    //     ]);
        
        
    // }
}
