<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class RegistrationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $customer;
    public $registration;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($customer,$registration_number)
    {
        $this->customer = $customer;
        $this->registration = $registration_number;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.registration');
    }
}
