<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MaterialIssueRequest extends Model
{

    const with_purchase_request = 0;
    const without_purchase_request = 1;

    protected $table = 'material_issue_requests';

    protected $fillable = [
        'pr_id',
        'request_person_name',
        'request_date',
        'department_id',
        'status',
        'mir_type',
    ];

    public function requestingItems()
    {
    return $this->hasMany('App\MaterialIssueRequestData' , 'mir_id');
    }

    public function department() {
    return $this->belongsTo('App\Department');
    }
}
