<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MergingProperty extends Model
{
    
    protected $table = 'merging_properties';
    
     protected $fillable = [
        'mrf_no',
        'maf_no',
        'property_code',
        'requested_by',
        'contact_no',
        'sale_agent_name',
        'city',
        'street',
        'phase',
        'area',
        'address',
        'demand_for_property',
        'details',
        'merging_value',
        'merging_assessed_value',
        'appraised_by',
        'appraised_by_sale_agent',
        'assessment_amount',
        'assessment_adjusted_against',
        'employee_id',
        'visit_time',
        'contact_person_at_location',
        'contact_person_no',
        'requestor_accompanied',
        'is_approve',
        
    ];
    
     public function city_name(){
        return $this->belongsTo('App\City','city');
    }
}
