<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class MultiProject extends Model
{
    //
    public function type(){

      
        return $this->belongsTo('App\ProjectType','project_type_id','id');
    }
    
    public function role()
    {
        return $this->belongsToMany(Role::class, 'multiproject_role',  'multi_project_id','role_id');
    }
    public static function getMultiProject(){
        $data=array();
        $user = Auth::user();
        $data['projects'] = $user->roles()->with('projects')->get()->pluck('projects')->flatten()->unique('id');
        $projectId = request()->cookie('current_project_id');
       
        $data['pro_id']=0; 

        if (!empty($projectId)) {
         
            $data['pro_id']=   decrypt( $projectId);
        }else
        {
            
            $mproject=  MultiProject::where('name','like','Super Admin')->first();
            if(empty($mproject)){

                return $data;
            }
           
            $projectId=  $mproject->id;
            $user = Auth::user();
            $role = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                $query->where('multi_project_id', $projectId);
            })      
          ->first(); 
           
          if(!empty($role)){
            $projectId = request()->cookie('current_project_id');
            if(empty( $projectId)){
                $data['pro_id']= 0;
            }else{
       
            $data['pro_id']= $projectId;
            }
            return $data;
          }

        }
        return $data;
    }
    public static function getActiveProject(){

        $data=array();
        $user = Auth::user();
        
        $projectId = request()->cookie('current_project_id');
       
        $data['pro_id']=0; 

        if (!empty($projectId)) {
         
            $data['pro_id']=   decrypt( $projectId);
            $pro_id =  $data['pro_id'];
          $data['project']=  MultiProject::where('id', $data['pro_id'])->first();
    //       $data['other_projects'] = $user->roles()->with(['projects' => function ($query) use (  $pro_id) {
    //         $query->where('multi_project_id', '!=',  $pro_id);
    //     }])
       
    // ->get();
    $data['other_projects'] = $user->roles()->with(['projects' => function ($query) use (  $pro_id) {
                $query->where('multi_project_id', '!=',  $pro_id);
            }])->get()->pluck('projects')->flatten()->unique('id')->first();
  

           
          return $data;

        } 
        else{

            $data['other_projects'] = $user->roles()->with('projects' )->get()->pluck('projects')->flatten()->unique('id')->first();
  

           
          return $data; 
        }
    }
}
