<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class NOC extends Model
{
    protected $table = 'noc';

    protected $fillable = [
    'noc_no',
    'customer_id',
    'unit_number_id',
    'status',
    'noc_date',
    ];

    public function customer()
    {
        return $this->belongsTo('\App\Customer', 'customer_id');
    }
    
    public function unitNumber()
    {
        return $this->belongsTo('\App\Inventory', 'unit_number_id');
    }


}