<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OpenFileDealerInfo extends Model
{
    //


    public function inventory()
    {
        return $this->belongsTo('\App\Inventory','invertory_id');
    }

    public function dealerPackage(){
        return $this->belongsTo('\App\DealerPackage', 'dealer_package_id');

    }

    public function dealer(){
        return $this->belongsTo('\App\Dealer', 'dealer_id');

    }
    public function cancelOpenFile()
    {
        return $this->hasOne('\App\CancelOpenFile', 'openfile_dealer_info_id');
    }

    public function dealerRefundOpenFileUnitReceipts()
    {
        return $this->hasOne('\App\DealerRefundOpenFileUnitReceipt', 'openfile_dealer_info_id');
    }

    public function dealerOpenFileCancelReceipt()
    {
        return $this->hasOne('\App\DealerOpenFileCancelReceipt', 'openfile_dealer_info_id');
    }
    public function endUserForm(){
        return $this->hasOne('\App\OpenFileDealerEndUserInfo', 'openfile_dealer_info_id');
    }


    static public function getDetail($dealer_package_id,$unit_type_id,$unit_size_id)
    {
        $openfile=OpenFileDealerInfo::where([['dealer_package_id', $dealer_package_id], ['unit_type_id', $unit_type_id], ['unit_size_id', $unit_size_id]])->get();

        return $openfile;
    } 
}
