<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;



class OpenFilePackage extends Model
{
  

    public function packageDetail()
    {
        return $this->hasMany(OpenFilePackageDetail::class, 'openfile_package_id');
    }

    public function dealer()
    {
        return $this->belongsToMany('\App\Dealer', 'dealer_packages');
    }

    public function pricelist()
    {
        return $this->belongsTo('\App\PriceList', 'pricelist_id');
    }
    
    public function insertData($request)
    {
        DB::beginTransaction();
        try {
            $openfilepackage = new OpenFilePackage;
            $openfilepackage->name = $request->package_name;
            $openfilepackage->pricelist_id = $request->pricelist_id;
            $openfilepackage->total_price = $request->package_price;
            // if ($request->rebatetype == 'cash') {
                $openfilepackage->rebate_amount = $request->rebate_amount;
            // }
            if ($request->rebatetype == 'openfile') {
                $openfilepackage->remaining_rebate = $request->remaining_rebate_amount;
                // $openfilepackage->rebate_amount = $request->rebate_amount;
            }
            $openfilepackage->rebate_type = $request->rebatetype;
            $openfilepackage->save();
            foreach ($request->unit_type as $key => $unit_id) {
                $openfilepackagedetail = new OpenFilePackageDetail;
                $openfilepackagedetail->openfile_package_id = $openfilepackage->id;
                $openfilepackagedetail->unit_type_id = $unit_id;
                $openfilepackagedetail->unit_size_id = isset($request->unit_size[$key]) ? $request->unit_size[$key] : '';
                $openfilepackagedetail->unit_quantity = isset($request->unit_quantity[$key]) ? $request->unit_quantity[$key] : '';
                $openfilepackagedetail->dealer_rebate = isset($request->dealer_rebate[$key]) ? $request->dealer_rebate[$key] : '';
                $openfilepackagedetail->dealer_downpayment = isset($request->dealer_downpayment[$key]) ? $request->dealer_downpayment[$key] : '';
                $openfilepackagedetail->save();
            }
            if ($request->rebatetype == 'openfile') {
                foreach ($request->rebate_unit_type as $key => $unit_id) {
                    $openfilepackagedetail = new OpenFilePackageDetail;
                    $openfilepackagedetail->openfile_package_id = $openfilepackage->id;
                    $openfilepackagedetail->unit_type_id = $unit_id;
                    $openfilepackagedetail->unit_size_id = isset($request->rebate_unit_size[$key]) ? $request->rebate_unit_size[$key] : '';
                    $openfilepackagedetail->unit_quantity = isset($request->rebate_unit_quantity[$key]) ? $request->rebate_unit_quantity[$key] : '';
                    $openfilepackagedetail->dealer_rebate = isset($request->rebate_dealer_rebate[$key]) ? $request->rebate_dealer_rebate[$key] : '';
                    $openfilepackagedetail->dealer_downpayment = isset($request->rebate_dealer_downpayment[$key]) ? $request->rebate_dealer_downpayment[$key] : '';
                    $openfilepackagedetail->rebate_file = 1;
                    $openfilepackagedetail->save();
                }
            
            }
        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }

        DB::commit();
        return $openfilepackage;
    }
    public function updateTable($filters,$ids) {

        
        $query = DealerPackage::where([['is_deleted', false]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
                            })
        ;

        foreach($filters as $key => $val) 
        {
            if($key == 'status')
                $query = $query->where('payment_status',$val);
            elseif($key == 'openfilepackage')
                $query = $query->whereHas('package',function($query) use($val){
                    $query->where('id',$val);
                });
            elseif($key == 'date')
                  $query = $query->where('issue_date',$val);
            elseif($key == 'dealer')
                $query = $query->whereHas('dealer',function($query) use($val){
                        $query->where('id',$val);
                      });
            elseif ($key == 'package_inventory')   
             $query = $query->where('inventory_status',$val);
             elseif ($key == 'multipro')   
             $query = $query->where('multi_project_id',$val);
        }

        
        $data['dealer_openfile_package'] = $query->get();
      
       

        return $data;
    }
}
