<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Otp extends Model
{
    private static $REASON_LOGIN = 'REASON_LOGIN';
    private static $REASON_REGISTER = 'REASON_REGISTER';


    public static function getLastLoginOTPWithinLastHour($phone_number)
    {
        return Otp::where('phone_number', $phone_number)
            ->where('reason', self::$REASON_LOGIN)
            ->where('created_at', '>', Carbon::now()->subMinutes(15)->toDateTimeString())
            ->orderBy('id', 'desc')
            ->first();
    }


    public static function createLoginOTP($phone_number)
    {
        $otp = new Otp();
        $otp->phone_number = $phone_number;
        $otp->otp = random_int(10000, 99999);
        $otp->reason = self::$REASON_LOGIN;
        $otp->save();
        return $otp;
    }

}
