<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use DB;

class Payment extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'customer_id', 'property_id', 'payment_head','payment_mode',
        'bank_name','cheque_number','cheque_title','amount','receipt_no',
        'receipt_date','reference_no','receipt_id'
    ];

    //payment mode
    const cash = 1;
    const bank = 2;
    const cheque = 3;
    const dd = 4;
    const pay_order = 5;
    const online_transfer =6 ;
    const adjacement = 7;

    //Payement Type
    const buy_back = 2;
    const full_payment_installment = 1;

    public function customer() {
        return $this->belongsTo('\App\Customer');
    }

    public function property() {
        return $this->belongsTo('App\CustomerProperty','property_id')->with('inventory');
    }

    public function statement() {
        return $this->hasOne('App\CustomerStatement');
    }

    public function DepositorBank(){
        return $this->belongsTo('App\DepositorBank','bank_name');
    }

    public function companyAccount() {
        return $this->belongsTo('\App\CompanyBank','company_account');
    }

    public function insertPayment($request) {
        $input=$request->all();
        $payment = Payment::create($input);

            $remaining_amount = $request->amount;
            while($remaining_amount > 0) {

            $property =  CustomerPropertyFullPaymentStatement::where('property_id',$request->property_id)->where('received', '<', DB::raw('due'))->first();


            if(($property->due - ($property->received ? $property->received : 0)) < $remaining_amount) {
                $amount = $property->due - $property->received;
                $remaining_amount -=$amount;
            }
            else {
                $amount = $remaining_amount;
                $remaining_amount = 0;

            }


            CustomerPropertyFullPaymentStatement::where('id',$property->id)->update(['receipt_no'=>$request->receipt_no,'receipt_date'=>$request->receipt_date,'received'=>$property->received + $amount,'payment_id'=>$payment->id]);


            }

            //update balance
            CustomerPropertyFullPaymentStatement::where('id',$property->id)->update(['balance'=>$property->balance - $amount]);



        return $payment;
    }

    public function updateReceipt($request) {

        $receipt = Receipt::where('id',$request->id)->first();

        //delete previous record
        $cBank = CompanyBank::where('id',$receipt->company_account)->first();
        if($cBank) {

                CompanyBank::where('id',$receipt->company_account)->update(['amount'=>$cBank->amount - $receipt->amount ]);
       //make transation
            CompanyBankTransaction::where('receipt_id', $receipt->id)->delete();

                }

        //dd($request);
        //update company account
        if($request->payment_mode != Receipt::cash){

            $cBank = CompanyBank::where('id',$request->company_account)->first();
            if($cBank) {
                CompanyBank::where('id',$request->company_account)->update(['amount'=>$cBank->amount + $request->amount ]);

                //make transation
            CompanyBankTransaction::create(['receipt_id' => $request->id, 'company_account' => $request->company_account]);

            }

        }

        Receipt::where('id',$request->id)->update(Input::except('_token','statement_id'));
        //update customer record
        $customer = Customer::where('id',$request->customer_id)->first();
        Customer::where('id',$request->customer_id)->update(['total_paid_amount'=>$customer->total_paid_amount - $receipt->amount + $request->amount]);

        //check if paymenthead change or not
        if((int)$receipt->payment_head == $request->payment_head) {

            //update the customer statement
            CustomerStatement::where('id',$request->statement_id)->update(['rcpt_no'=>$request->receipt_no,
                            'ref_no'=>'RC'.$receipt->id,'rcpt_date'=>$request->receipt_date,
                       'rcpt_amount'=>$request->amount,'received'=>$request->amount,'receipt_id'=>$request->id]);

            //check surcharge apply or not
            $property =  CustomerStatement::where('id',$request->statement_id)->first();

            $pay = new Carbon($property->rcpt_date);
            $due = new Carbon($property->due_date);
            if($pay > $due) {

                $latedays = $pay->diffInDays($due);

                CustomerStatement::where('id',$request->statement_id)->update(['late_days'=>$latedays,
                        'surcharge'=>$latedays * 100]);
            }

            //update the customer record
            CustomerStatement::where('id',$request->statement_id)->update(['balance'=>$property->due - $request->amount]);
        }
        else {
            $property = CustomerStatement::where('id',$request->statement_id)->first();
            //delete the previous record
            CustomerStatement::where('id', $request->statement_id)->update(['rcpt_no' => null,
                'ref_no' => null, 'rcpt_date' => null, 'rcpt_amount' => 0, 'received' => 0,
                'late_days' => 0, 'surcharge' => 0,'receipt_id'=>null,'balance'=>$property->due]);

            //check payment head is installment or other
            if ((int)$request->payment_head !== Receipt::installment) {

                CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                    , ['payment_head', $request->payment_head]])->update(['rcpt_no' => $request->receipt_no,
                    'ref_no' => 'RC'.$receipt->id, 'rcpt_date' => $request->receipt_date,
                    'rcpt_amount' => $request->amount, 'received' => $request->amount,'receipt_id'=>$request->id]);

                //check surcharge apply or not
                $property = CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                            , ['payment_head', $request->payment_head]])->first();

                $pay = new Carbon($property->rcpt_date);
                $due = new Carbon($property->due_date);
                if ($pay > $due) {

                    $latedays = $pay->diffInDays($due);

                    CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                        , ['payment_head', $request->payment_head]])->update(['late_days' => $latedays,
                        'surcharge' => $latedays * 100]);
                }

                //update balance
                CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                    , ['payment_head', $request->payment_head]])->update(['balance' => $property->due - $request->amount]);
            }
            else {

                $property = CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                            , ['payment_head', $request->payment_head], ['received', null]])->first();


                CustomerStatement::where('id', $property->id)->update(['rcpt_no' => $request->receipt_no,
                    'ref_no' => 'RC'.$receipt->id, 'rcpt_date' => $request->receipt_date,
                    'rcpt_amount' => $request->amount, 'received' => $request->amount,'receipt_id'=>$request->id]);

                $property = CustomerStatement::where('id', $property->id)->first();
                // dd($property->rcpt_date);
                $pay = new Carbon($property->rcpt_date);
                $due = new Carbon($property->due_date);
                if ($pay > $due) {

                    $latedays = $pay->diffInDays($due);

                    CustomerStatement::where('id', $property->id)->update(['late_days' => $latedays,
                        'surcharge' => $latedays * 100]);
                }

                //update balance
                CustomerStatement::where('id', $property->id)->update(['balance' => $property->due - $request->amount]);
            }
        }


        return $receipt;
    }


    public function deletePayment($id) {

        $payment = Payment::where('id',$id)->first();

        //Delete Previous entries
        $customer = Customer::where('id',$receipt->customer_id)->first();
        Customer::where('id',$receipt->customer_id)->update(['total_paid_amount'=>$customer->total_paid_amount - $receipt->amount]);

             CustomerPropertyFullPaymentStatement::where('payment_id',$id)->update(['receipt_no'=>null,'ref_no'=>null,'receipt_date'=>null,'amount'=>0,'received'=>0,'late_days'=>0,'surcharge'=>0]);



        Payment::where('id',$id)->delete();

        return $payment;
    }


}
