<?php
namespace App;

use Illuminate\Database\Eloquent\Model;

class PermissionRole extends Model
{
    protected $table = 'permission_role';
    public $timestamps = false;

    protected $fillable = [
        'permission_id',
        'role_id'
    ];

    public function user()
    {
        return $this->hasMany(PermissionRole::class, 'role_id');
    }

    public function hasperm()
    {
        return $this->hasMany(Permission::class, 'Permission_role');
    }
}
