<?php

namespace App\Policies;

use App\MultiProject;
use App\Role;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class RolePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function check(User $user, $role)
    {
         
        
        try {
            $roles = [];
            if (is_array($role)) {

                $roles =  $role;
            } else {
                $roles[] =  $role;
            }
            // $roles = json_decode(str_replace("'", '"', $role));

            // if(!is_array($roles)){
            //    $roles = explode(',', $roles);
            // }

            $mproject =  MultiProject::where('name', 'like', 'Super Admin')->first();
            if (empty($mproject)) {
                return false;
            }
            $multiProjectId = $mproject->id;;
            $projectId = request()->cookie('current_project_id');


            if (!empty($projectId)) {
                $projectId = decrypt($projectId);
                if ($multiProjectId ==  $projectId) {

                    if (in_array('otheradmin', $roles)) {
                        $index = array_search('otheradmin', $roles);

 
                           if ($index !== false) {
                                  unset($roles[$index]);
                                 }
                        $roles = $user
                        ->roles()
                               
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->get();
                       
                        
                    }
                    else{
                    $roles = $user
                        ->roles()
                        ->whereIn('name', $roles)
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->get();
                       
                    }

                    if ((sizeof($roles) > 0)) {


                        return true;
                    }
                } else
                    return false;
            }
            else{
                if ($multiProjectId ==  $projectId) {
                    if (in_array('otheradmin', $roles)) {
                        $index = array_search('otheradmin', $roles);

 
                        if ($index !== false) {
                               unset($roles[$index]);
                              }
                        $roles = $user
                        ->roles()
                        
                        
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->get();

                    }
                    else{
                        $roles = $user
                        ->roles()
                        ->whereIn('name', $roles)
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->get();

                    }
                   

                    if ((sizeof($roles) > 0)) {


                        return true;
                    } 
                }
            }

            return false;
        } catch (\Exception $e) {

            return false;
        }
    }

    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\User  $user
     * @param  \App\Role  $role
     * @return mixed
     */
    public function view(User $user, Role $role)
    {
        //
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\User  $user
     * @param  \App\Role  $role
     * @return mixed
     */
    public function update(User $user, Role $role)
    {
        //
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\User  $user
     * @param  \App\Role  $role
     * @return mixed
     */
    public function delete(User $user, Role $role)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\User  $user
     * @param  \App\Role  $role
     * @return mixed
     */
    public function restore(User $user, Role $role)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\User  $user
     * @param  \App\Role  $role
     * @return mixed
     */
    public function forceDelete(User $user, Role $role)
    {
        //
    }
}
