<?php

namespace App;

 
use Illuminate\Database\Eloquent\Model;
use DB;

class PriceList extends Model
{    
    public function pricedetail()
    {
        return $this->hasMany('\App\PriceListDetail', 'pricelist_id');
    }

    public function projecttype()
    {
        return $this->belongsTo('\App\ProjectType', 'project_type_id');
    }

    public function typee()
    {
        return $this->belongsTo('App\UnitType','unit_type_id');
    }
   
    public static function getUniqueList()
    {    
        $listnumber = PriceList::select('l_no')->where('l_no','like','LN-%')->latest('id')->first();
        if(!empty($listnumber))
        {
            $number= str_replace( 'LN-',"",$listnumber ? $listnumber->l_no : 1);
            $val =$number + 1;
            return $val;
        }

        else
        {
            return '1';
        }
    }

    public function insertDetail($request)
    {        
        DB::beginTransaction();
        $pricelist = new PriceList ;
        try{

            // if ($request->project_type == ProjectType::high_rise) {
            //     $pricelist->project_type_id = ProjectType::high_rise;
            //     $pricelist->l_no = $request->list_number;
            //     $pricelist->save();
            //     $pricelist_detail = new PriceListDetail;
            //     $pricelist_detail->pricelist_id = $pricelist->id;
            //     $pricelist_detail->price = $request->high_rise_price;
            //     $pricelist_detail->save();
    
    
            // } else
            //  if ($request->project_type == ProjectType::society) {
    
                // dd( ProjectType::society);
                $pricelist->project_type_id = $request->project_type;
                $pricelist->l_no = $request->list_number;
                $pricelist->save();
            if ($request->project_type == ProjectType::high_rise) {
                foreach ($request->unit_floor as $key => $unit_floor_id) {
                    $pricelist_detail = new PriceListDetail;
                    $pricelist_detail->pricelist_id = $pricelist->id;
                    $pricelist_detail->unit_floor_id = $unit_floor_id;
                    
                    $pricelist_detail->unit_type_id = isset($request->unit_type[$key]) ? $request->unit_type[$key] : null;
                    // $pricelist_detail->unit_size_id = isset($request->unit_size[$key]) ? $request->unit_size[$key] : '';
                    $pricelist_detail->per_size_price = isset($request->per_price[$key]) ? $request->per_price[$key] : 0;
                    // $pricelist_detail->total_price = isset($request->total_price[$key]) ? $request->total_price[$key] : 0;
                    $pricelist_detail->save();
                }
            } elseif ($request->project_type == ProjectType::society) {
                foreach ($request->unit_type as $key => $unit_id) {
                    $pricelist_detail = new PriceListDetail;
                    $pricelist_detail->pricelist_id = $pricelist->id;
                    $pricelist_detail->unit_type_id = $unit_id;
                    $pricelist_detail->unit_size_id = isset($request->unit_size[$key]) ? $request->unit_size[$key] : '';
                    $pricelist_detail->per_size_price = isset($request->per_price[$key]) ? $request->per_price[$key] : 0;
                    $pricelist_detail->total_price = isset($request->total_price[$key]) ? $request->total_price[$key] : 0;
                    $pricelist_detail->save();
                }
            }
    
            // }
        }
        catch (\Exception $e) 
        { 
            DB::rollback();
            return false;
        }

        DB::commit();
        return $pricelist;
    }
    public function  updateDetail($request,$pricelist_id)
    {        
        DB::beginTransaction();
       
        try{

            if ($request->project_type == ProjectType::high_rise) {
                PriceListDetail::where('pricelist_id', $pricelist_id)->delete();

                foreach ($request->unit_type as $key => $unit_id) {
                    $pricelist_detail = new PriceListDetail;
                    $pricelist_detail->pricelist_id = $pricelist_id;
                    $pricelist_detail->unit_type_id = $unit_id;
                    $pricelist_detail->unit_floor_id = $request->unit_floor[$key];

                    $pricelist_detail->per_size_price = isset($request->per_price[$key]) ? $request->per_price[$key] : 0;

                    $pricelist_detail->save();

                    $inventories = Inventory::where([['unit_floor_id', $pricelist_detail->unit_floor_id], ['unit_type_id', $pricelist_detail->unit_type_id], ['pricelist_id', $pricelist_id], ['status', Inventory::open]])->get();
                    foreach ($inventories as $inventory) {
                        $size_val= $inventory->size->name;
                        $total=  $pricelist_detail->per_size_price   *  $size_val;
                        $inventory->total_price =$total;
                        $inventory->save();
                    }
                }
    
    
            } else
             if ($request->project_type == ProjectType::society) {
    
                // dd( ProjectType::society);
            PriceListDetail::where('pricelist_id', $pricelist_id)->delete();
    
                foreach ($request->unit_type as $key => $unit_id) {
                    $pricelist_detail = new PriceListDetail;
                    $pricelist_detail->pricelist_id = $pricelist_id;
                    $pricelist_detail->unit_type_id = $unit_id;
                    $pricelist_detail->unit_size_id=    isset($request->unit_size[$key])?$request->unit_size[$key]:'';
                    $pricelist_detail->per_size_price = isset($request->per_price[$key]) ? $request->per_price[$key] : 0;
                    $pricelist_detail->total_price = isset($request->total_price[$key]) ? $request->total_price[$key] : 0;
                    $pricelist_detail->save();

             $inventories=   Inventory::where([['unit_size_id', $pricelist_detail->unit_size_id], ['unit_type_id', $pricelist_detail->unit_type_id], ['pricelist_id', $pricelist_id], ['status', Inventory::open]])->get();
                foreach ($inventories as $inventory) {

                    $inventory->total_price = $pricelist_detail->total_price;
                    $inventory->save();
                }


                    
                }
    
            }
        }
        catch (\Exception $e) 
        { 
            DB::rollback();
            return false;
        }

        DB::commit();
        return true;
    }
   

}