<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;

class ProjectAccount extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'inventory_id','payment_head','amount','depositor_name','payment_type','description','date','adjacement_type','pay_order_title','pay_order_date','pay_order_bank_id'
    ];

    //types
    const pay_order = 1;
    const adjacement = 2;
    const others = 3;

    //Payement Head
    const booking = 1;
    const confirmation = 2;
    const installment = 3;
    const possession = 4;
    const full_payment = 5;

    //adjacement
    const property = 1;
    const vehicle = 2;


    public function inventory()
    {
        return $this->belongsTo('\App\Inventory');
    }

    public function bank() {
        return $this->belongsTo('\App\DepositorBank','pay_order_bank_id');
    }

    public function files() {
        return $this->hasMany('\App\ProjectAccountFile');
    }

    public function insertAmount($request) {

        $amount = ProjectAccount::create(Input::except('images',
            '_token'));

        if($request->hasfile('images'))
         {

            foreach($request->file('images') as $image)
            {
                $name = $amount->id . '-' . $image->getClientOriginalName();
                $image->move(public_path().'/uploads/', $name);

                ProjectAccountFile::create(['project_account_id' => $amount->id, 'file_url' => $name]);
            }
         }

      return $amount;
    }

    public function updateAmount($request) {

        ProjectAccount::where('id',$request->id)->update(Input::except('images','_token'));

        if($request->hasfile('images'))
         {

            foreach($request->file('images') as $image)
            {
                $name = $request->id . '-' . $image->getClientOriginalName();
                $image->move(public_path().'/uploads/', $name);

                ProjectAccountFile::create(['project_account_id' => $request->id, 'file_url' => $name]);
            }
         }

    }
}
