<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PropertyChatHistory extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
     
    protected $table ='property_chat_histories';
    
    protected $fillable = [
        'property_id','remarks','next_follow_up','user_id','status','user_assign',
    ];

    public function property() {
        return $this->belongsTo('\App\CustomerProperty','property_id');
    }
    public function user() {
        return $this->belongsTo('\App\User');
    } 
    
     public function user_asign() {
        return $this->belongsTo('\App\User','user_assign');
    }
}
