<?php

namespace App\Providers;

use App\MultiProject;
use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Auth;
class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'App\Model' => 'App\Policies\ModelPolicy',
        'App\Permission' => 'App\Policies\PermissionPolicy',
        
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

         /* define a admin user role */
         Gate::define('isSuperAdmin', function($user) {
            $mproject=  MultiProject::where('name','like','Super Admin')->first();
            if(empty( $mproject)){
                return false;
              }
            $projectId =  $mproject->id;
            $project_id = request()->cookie('current_project_id');
            $user = Auth::user();
            if(!empty(  $project_id )){

                $pro_id = decrypt($project_id);
                if($mproject->id ==  $pro_id ){
                    
                    $role = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                        $query->where('multi_project_id', $projectId);
                    })      
                  ->first();  
                //   dd($role);
                  if(!empty($role)){
          
                    return true;
                  }
                  return false;
                }
                  return false;
            }
         
            
           
            $role = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                $query->where('multi_project_id', $projectId);
            })      
          ->first(); 
          if(!empty($role)){
          
            return true;
          }
         
          
            return false;
         });

         Gate::define('has-permission', function ($user, $permission) {
          $permissionName=[];
          if(is_array($permission)){
              // $permissionName = json_decode(str_replace("'", '"', $permission));
              $permissionName =  $permission;
             }
             else
             {
              $permissionName[] =  $permission;
             }
             $projectId = request()->cookie('current_project_id');
             if (empty($projectId)) 
             {
              return false;
             }
          $projectId= decrypt( $projectId);
       
          if ($user && $projectId) {
              $roles = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                  $query->where('multi_project_id', $projectId);
              })->get();
              foreach ($roles as $role) {
                  $permissions = $role->permissions()->whereIn('name', $permissionName)->get();
                 
                  if ($permissions->count() > 0) {
                      return true;
                  }
                  
             
              }
               // Clear the cached permissions
              
          }
          return false;
          // return $user->hasPermission($permission);
      });
      Gate::define('has-role', function ($user, $role) {
     
        $roles=[];
        if(is_array($role)){
            
            $roles =  $role;
           }
           else
           {
            $roles[] =  $role;
           }
        // $roles = json_decode(str_replace("'", '"', $role));
  
        // if(!is_array($roles)){
        //    $roles = explode(',', $roles);
        // }
    
           $mproject=  MultiProject::where('name','like','Super Admin')->first();
         if(empty($mproject)){
           return false;
         }
         $multiProjectId = $mproject->id;
         ;
           $roles = $user
           ->roles()
           ->whereIn('name', $roles)
             
           ->whereHas('projects', function ($query) use ($multiProjectId) {
               $query->where('multi_project_id', $multiProjectId);
           })
           ->get();
    
   
           if ( (sizeof($roles) > 0)) {
              
   
                return true;
           }
            
           
           return false;
    });
        //
    }
}
