<?php

namespace App\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Auth\Events\Logout;
use Illuminate\Auth\Events\TokenExpired;
use Illuminate\Http\Response;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'App\Events\Event' => [
            'App\Listeners\EventListener',
        ],
        'App\Events\ImportProgressUpdated' => [
            'App\Http\Livewire\ImportExcel',
        ],
        
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
        
        Event::listen([Logout::class, AccessTokenExpired::class], function ($event) {
            setcookie('current_project_id', '', time()-1000);
            
        });

        //
    }
}
