<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
 
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use App\SchedulePlan;
use App\Inventory;
use App\CustomerProperty;
use App\DealerPackage;
use App\DealerPackageReceipt;
use App\Receipt;
 
use App\ProjectType;
use App\DevelopmentCharges;

use App\Traits\MultiProjectCookie;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\App;

class ViewServiceProvider extends ServiceProvider
{
    use MultiProjectCookie;
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
        // App::afterResolving(function () {
        //     $project_id = $this->decryptCookieValue();
        //     // Do something with the decrypted value...
        // });
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        date_default_timezone_set('Asia/Karachi');
       // Handle the case where the cookie value is empty
       View::composer('*', function ($view) {

        $schedule =collect();
        $units=  collect();
          $pendingStatements= collect();
          $pendingReceipts=  collect();
  
           $pendingPackage=  collect();
         $pendingDealerReceipt=  collect();
         $project_type= null;
          $pendingdevelopment_charges=  collect();
          
        $data=    $this->getProjectIds();
        if($data['status'] == 'success'){
        $ids=[];
        if(is_array($data['project_ids'])){
            $ids=    $data['project_ids'];
           }
           else
           {
            $ids[]=    $data['project_ids'];
           }
           
       
        
        $schedule = SchedulePlan::first();
        $units = Inventory::orderBy('unit_number','asc')
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        })
        ->select('unit_number','id')->get();

        $pendingStatements = CustomerProperty::where([['status',CustomerProperty::pending],['is_deleted',false]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        })
        
        ->count();
        $pendingReceipts = Receipt::where([['is_approved',false],['is_deleted',false],['cheaque_status' , Receipt::pending]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        })
        ->count();

        $pendingPackage = DealerPackage::where([['is_approved', 0],['is_deleted',0]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        })
        ->count();
      
        $pendingDealerReceipt = DealerPackageReceipt::where([['is_approved', 0],['is_deleted',0]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        })
        ->count();

        $project_type=  ProjectType::where('status', 1)->first();
        // customerProperty
         $pendingdevelopment_charges = DevelopmentCharges::where([['is_approved', 0]])
        //  ->when($ids[0] !== 'all', function ($query) use ($ids) {
        //     $query->whereIn('multi_project_id', $ids);
        // })
         ->count();
       

       
        }

      
      





        View::share('schedule',$schedule);
        View::share('units',$units);
        View::share('pendingStatements',$pendingStatements);
        View::share('pendingReceipts',$pendingReceipts);

        View::share('pendingPackage',$pendingPackage);
        View::share('pendingPackageReceipt',$pendingDealerReceipt);
        View::share('projectType',$project_type);
        View::share('pendingDevelopmentCharges',$pendingdevelopment_charges);
    });
      
   
        
        
        
    }
   
}
