<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
     protected $fillable = [
      'purchase_request_id',
      'vendor_id',
      'status',
      'receiver_name',
      'receiving_date',
      'delivery_date',
      'special_instruction',
      'payment_terms',
      'cs_purchase_manager_date',
      'cs_purchase_officer_date',
      'total_amount',
      'advance',
    ];
   
    public function purchaseOrderItems()
    {
      return $this->hasMany('App\ItemPurchaseOrder' , 'purchase_order_id');
    }

     public function purchaseOrderReceipts()
    {
      return $this->hasMany('App\PurchaseOrderReceipt' , 'purchase_order_id');
    }

    public function vendor()
    {
      return $this->belongsTo('App\PurchaseRequestVendor');
    }

         public function csApprovalStatus()
   {
      return $this->hasMany('App\CsApproval' , 'purchase_order_id');
   }

    public function scopeWithAndWhereHas($query, $relation, $constraint){
  return $query->whereHas($relation, $constraint)
  ->with([$relation => $constraint]);
  }

    public  static function getVendorIds($purchase_request_id=null)
    {
        $total_cs = PurchaseOrder::where('purchase_request_id' , $purchase_request_id)->where('status' , '!=' , 0)
        ->pluck('vendor_id')->toArray();
        return array_unique($total_cs);
    }

     public static function getVendorItems( $vendor_id = null  , $purchase_request_id  = null )
    {
       
        $vendor_items =   PurchaseOrder::where('vendor_id' ,   $vendor_id )
        ->where('purchase_request_id' , $purchase_request_id )
        ->pluck('item_id')->toArray();

        return ItemPurchaseRequest::where('purchase_request_id' ,  $purchase_request_id)
        ->whereIn('item_id' , $vendor_items )
        ->get();
    }
    

    public  static function getReceivedItemQuantity($purchase_order_id=null , $item_id = null)
    {
      
       return ItemPurchaseOrder::where('purchase_order_id' , $purchase_order_id)->where('item_id' , $item_id)->first()->received_quantity;

    }

    static function getStatusOfPurcchaseOrder($pr_id = null , $vendor_id = null )
    {
       return PurchaseOrder::where('purchase_request_id' , $pr_id)->where('vendor_id' , $vendor_id)->first();
    }

    public static function getPurchaseOrderTotalItems($po_id = null , $pr_id = null )
    {
       return ItemPurchaseOrder::where('purchase_order_id' , $po_id)->where('purchase_request_id' , $pr_id)->count();
    }

    public static function getSinglePOItems($po_id = null , $pr_id = null , $item_id)
    {
       return ItemPurchaseOrder::where('purchase_order_id' , $po_id)->where('purchase_request_id' , $pr_id)->where('item_id' , $item_id)->first()->demand_quantity;
    }

    public static function getPurcchaseOrder($po_id = null , $vendor_id = null )
    {
       return PurchaseOrder::where('id' , $po_id)
       ->where('vendor_id' , $vendor_id)
       ->first();
    }

    public static function getStatusOfVendorPo($pr_id = null , $vendor_id = null , $item_id = null)
    {
       $current_item_status = 0;
       $quantity = null;
       $po =  PurchaseOrder::where('purchase_request_id', '=', $pr_id)->where('vendor_id' , $vendor_id)->where('status'  , 0)->first();
       if ( $po == true) 
       {
           $item = ItemPurchaseOrder::where('purchase_order_id' , $po->id)->where('purchase_request_id' , $pr_id)->where('item_id' , $item_id)->first();
           if ( $item  == true)
           {
               $current_item_status = 1;
               $quantity = number_format($item->demand_quantity , 2);
           }
       }
       return [$current_item_status , $quantity];
    }

}