<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PurchaseOrderReceipt extends Model
{

     protected $table = 'purchase_order_receipt';

     protected $fillable = [
        'purchase_order_id',
        'vendor_id',
        'receipt_date',
        'purchase_request_id',
        'total_amount',
        'status',
        'receipt_pay_date',
        'total_pay_amount',
        'remaining_amount',
        'documents',
        'quality_insu_docs',
        'quality_test_inspector_name',
        'invoice_no',
        'account_officer_name',
        'account_officer_name_date',
        'po_receiver_name',
        'po_receiveing_date',
        'quality_test_inspector_date',
        'receipt_type',
    ];

    public $timestamps = false;


    public static function getStatusOfPOReceipt($pr_id = null , $vendor_id = null )
    {
       return PurchaseOrderReceipt::where('purchase_request_id' , $pr_id)->where('vendor_id' , $vendor_id)->first();
    }
    
     public function ReceiptItems()
    {
      return $this->hasMany('App\ReceiptItem' , 'purchase_order_receipt_id');
    }

     public function purchase_order()
    {
      return $this->belongsTo('App\PurchaseOrder' , 'purchase_order_id');
    }

    public static function getTotalReceipt($pr_id = null)
    {
       return  PurchaseOrderReceipt::where('purchase_request_id' , $pr_id)->count();
    }

}
