<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PurchaseRequestVendor extends Model
{
    
    protected $table = 'vendors';

     protected $fillable = [
        'name',
        'phone_number',
        'email',
        'cnic',
        'address',
        'ntn',
        'stn',
        'test_certificate'
    ];


  public function scopeWithAndWhereHas($query, $relation, $constraint){
  return $query->whereHas($relation, $constraint)
  ->with([$relation => $constraint]);
  }


    public function items()
    {
      return $this->belongsToMany('App\Item');
    }

   public function purchaseOrder()
    {
      return $this->hasMany('App\PurchaseOrder' , 'vendor_id');
    }

   public function comparativeStatements()
     {
      return $this->hasMany('App\ComparativeStatement' , 'vendor_id');
    }


     public function receipts()
   {
      return $this->hasMany('App\PurchaseOrderReceipt' , 'vendor_id');
   }

   public static function getPoStatus($vendor = null , $status = null)
   {
    $total = 0;
  
    $total_purchase_orders = PurchaseRequestVendor::withAndWhereHas('purchaseOrder', function($query) use ($status)
    {
    $query->where('status', $status);
    })
    ->where('id' , $vendor)
    ->first();


    if($total_purchase_orders  == true )
    {
      $total_purchase_orders = json_decode(json_encode($total_purchase_orders));
      $total =  count($total_purchase_orders->purchase_order);
    }

    return $total;
   }

    public static function getReceiptStatus($vendor = null , $status = null)
    {
    $total = 0;
    $total_receipts = PurchaseRequestVendor::withAndWhereHas('receipts', function($query) use ($status)
    {
    $query->where('status', $status);
    })
    ->where('id' , $vendor)
    ->first();

    if($total_receipts  == true)
    {
      $total_receipts = json_decode(json_encode($total_receipts));
      $total =  count($total_receipts->receipts);
    }
    
    return $total;

    }


}