<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use DB;
use App\Mail\InstallmentConfirmation;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\SmsController;
use App\Mail\ApproveInstallementReceiptMail;


class Receipt extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'customer_id',
        'customer_property_id',
        'payment_head',
        'payment_mode',
        'bank_name',
        'cheque_number',
        'cheque_title',
        'cheaque_status',
        'drawn_date',
        'amount',
        'receipt_no',
        'receipt_date',
        'reference_no',
        'receipt_id',
        'company_account',
        'adjustment_type',
        'adjustment_detail',
        'inventory_id',
        'is_deleted',
        'is_approved',
        'payment_method',
        'dealer_adjustment_unit_id',
        'vendor_purchase_order_id',
        'notes',
        'is_book',
        'tax_paid_by',
        'tax_payment_received',
        'tax_amount',
        'cancel_property_id',
        'notify_sms',
        'notify_email',
        'multi_project_id'
    ];
    //adjacement
    const property = 1;
    const vehicle = 2;
    const others = 3;
    const rebate = 4;
    const vendor = 5;
    const token_receipt = 6;

    const roll_back = 7;

    //payment mode
    const cash = 1;
    const bank = 2;
    const cheque = 3;
    const dd = 4;
    const pay_order = 5;
    const online_transfer = 6;
    const adjustment = 7;

    //Payement Head
    const token_amount = 9;
    const down_payment = 1;
    const possession_fee = 2;
    const installment = 3;
    const transfer_fee = 4;
    const semi_installment = 5;
    const full_payment = 6;
    const other = 7;
    const allotment = 8;
    const confirmation = 9;
    const booking = 10;
    const development = 11;
    const file_processing = 12;
    const registration = 13;
    const surcharge = 14;
    const merging = 15;

    const package_payment = 16;
    const package_rebate = 17;

    const ballon = 18;
    const balloting = 19;
    const semi_annual_installment = 20;

    const total_payment_head = 11;


    //tax pay by
    const customer = 1;
    const company = 2;
    const dealer = 3;

    // cheaque status
    const pending = 0;
    const approve = 1;
    const cancel = 2;

    public function customer()
    {
        return $this->belongsTo('\App\Customer');
    }

    public function property()
    {
        return $this->belongsTo('App\CustomerProperty', 'customer_property_id')->with('inventory');
    }

    public function statement()
    {
        return $this->hasOne('App\CustomerStatement');
    }

    public function documents()
    {
        return $this->hasMany('App\Receiptdocument', 'receipt_id');
    }

    public function DepositorBank()
    {
        return $this->belongsTo('App\DepositorBank', 'bank_name');
    }

    public function companyAccount()
    {
        return $this->belongsTo('\App\CompanyBank', 'company_account');
    }

    public function inventory()
    {
        return $this->belongsTo('\App\inventory', 'inventory_id');
    }

    public function paymentMode()
    {
        return $this->belongsTo('\App\ChartOfAccount', 'payment_mode');
    }

    public function rebate()
    {
        return $this->belongsTo('\App\dealerTransaction', 'dealer_adjustment_unit_id')->with('property');
    }

    public function cancelProperty()
    {

        return $this->hasMany('\App\CancelProperty', 'cancel_property_id');
    }
    public function multiProject()
    {
        return $this->belongsTo('\App\MultiProject', 'multi_project_id','id');
    }

    public function insertReceipt($request)
    {

        // dd($request->all());
        DB::beginTransaction();
        try {

            
            $cp= CustomerProperty::where('id',$request->customer_property_id)->first();
           $multiproject_id= $cp->inventory->multiproject?$cp->inventory->multiproject->id:null;
           $request->merge(['multi_project_id' => $multiproject_id]);
          
            $input = $request->all();
            
            $receipt = Receipt::create($input);

            if ($receipt->tax_paid_by == Self::company && $receipt->tax_payment_received == true)
                Receipt::where('id', $receipt->id)->update(['amount' => $receipt->amount]);

            if ($request->payment_method == Receipt::bank) {

                Receipt::where('id', $receipt->id)->update(['reconciled' => 0]);
            }

            if ($request->is_approved) {

                if ($request->payment_head == Receipt::down_payment) {
                    CustomerProperty::where('id', $request->customer_property_id)->update(['invoice_number' => $request->receipt_no]);
                }

                if ($request->payment_mode != Receipt::cash && $request->payment_mode != Receipt::adjustment) {
                    $cBank = CompanyBank::where('id', $request->company_account)->first();
                    if ($cBank) {
                        CompanyBank::where('id', $request->company_account)->update(['amount' => $cBank->amount + $request->amount]);

                        //make transation
                        CompanyBankTransaction::create(['receipt_id' => $receipt->id, 'company_account' => $request->company_account]);
                    }
                }

                if ($request->payment_mode == Receipt::adjustment) {
                    // dd('inside',$request->all());
                    if ($request->adjustment_type == Receipt::roll_back) {

                        $cancelproperty =  CancelProperty::where('id', $request->roll_back_properties)->first();

                        $total_received_amount =   $cancelproperty->customerAdjustHistory->total_received_amount;
                        CustomerAdjustment::create(['receipt_id' => $receipt->id, 'type' => $request->adjustment_type, 'description' => $request->adjustment_detail, 'merge_amount' =>  $total_received_amount]);
                    } else {
                        CustomerAdjustment::create(['receipt_id' => $receipt->id, 'type' => $request->adjustment_type, 'description' => $request->adjustment_detail, 'merge_amount' => $request->amount]);
                    }
                }

                //update customer record
                $customer = Customer::where('id', $request->customer_id)->first();
                Customer::where('id', $request->customer_id)->update(['total_paid_amount' => $customer->total_paid_amount + $request->amount]);
                //dd($request->payment_head);
                //update customer statement

                // $amount = $request->amount;
                $rem_amount = $request->amount;
                $remaining_amount = 0;
                while ($rem_amount > 0) {

                    //check payment head is installment or other
                    if ((int)$request->payment_head !== Receipt::installment) {

                        $statement = CustomerStatement::where([
                            ['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]
                        ])->first();

                        if (($statement->due - ($statement->received ? $statement->received : 0)) < $rem_amount) {
                            $amount = $statement->due - $statement->received;
                            $rem_amount -= $amount;
                        } else {
                            $amount = $rem_amount;
                            $rem_amount = 0;
                        }

                        if ($amount > 0) {

                            CustomerStatement::where([
                                ['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]
                            ])->update([
                                'rcpt_no' => $request->receipt_no,
                                'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $request->receipt_date,
                                'rcpt_amount' => $amount, 'received' => $statement->received + $amount, 'receipt_id' => $receipt->id
                            ]);
                        }

                        //check surcharge apply or not
                        $property =  CustomerStatement::where([['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]])->first();

                        $pay = new Carbon($property->rcpt_date);
                        $due = new Carbon($property->due_date);
                        if ($pay > $due) {

                            $latedays = $pay->diffInDays($due);

                            $fine_per = SchedulePlan::first()->fine;

                            CustomerStatement::where([
                                ['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]
                            ])->update([
                                'late_days' => $latedays,
                                'surcharge' => $latedays * $fine_per
                            ]);
                        }

                        //update balance
                        CustomerStatement::where([
                            ['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]
                        ])->update(['balance' => $property->balance - $amount]);
                    } else {

                        $remaining_amount = $rem_amount;

                        while ($remaining_amount > 0) {

                            $property =  CustomerStatement::where(
                                [
                                    ['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]
                                ]
                            )->where('received', '<', DB::raw('due'))->first();

                            if (($property->due - ($property->received ? $property->received : 0)) < $remaining_amount) {
                                $amount = $property->due - $property->received;
                                $remaining_amount -= $amount;
                            } else {
                                $amount = $remaining_amount;
                                $remaining_amount = 0;
                            }


                            CustomerStatement::where('id', $property->id)->update([
                                'rcpt_no' => $request->receipt_no,
                                'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $request->receipt_date,
                                'rcpt_amount' => $property->rcpt_amount + $amount, 'received' => $property->received + $amount, 'receipt_id' => $receipt->id
                            ]);

                            $property =  CustomerStatement::where('id', $property->id)->first();
                            // dd($property->rcpt_date);
                            $pay = new Carbon($property->rcpt_date);
                            $due = new Carbon($property->due_date);
                            if ($pay > $due) {

                                $latedays = $pay->diffInDays($due);


                                $fine_per = SchedulePlan::first()->fine;

                                CustomerStatement::where('id', $property->id)->update([
                                    'late_days' => $latedays,
                                    'surcharge' => $latedays * $fine_per
                                ]);
                            }

                            //update balance
                            CustomerStatement::where('id', $property->id)->update(['balance' => $property->balance - $amount]);
                        }
                        $rem_amount = $remaining_amount;
                    }


                    $request->payment_head++;
                }

                //if partiall payment then create new payment
                $partial_instllment = CustomerStatement::where([['payment_head', '!=', Receipt::down_payment], ['customer_property_id', $receipt->customer_property_id], ['received', '>', '0'], ['balance', '!=', 0]])->first();


                if ($partial_instllment) {
                    CustomerStatement::create(['customer_id' => $partial_instllment->customer_id, 'customer_property_id' => $partial_instllment->customer_property_id, 'payment_head' => $partial_instllment->payment_head, 'inst_no' => $partial_instllment->inst_no . '-b', 'due_date' => $partial_instllment->due_date, 'due' => $partial_instllment->due - $partial_instllment->received, 'balance' => $partial_instllment->due - $partial_instllment->received, 'surcharge' => 0]);

                    CustomerStatement::where('id', $partial_instllment->id)->update(['inst_no' => $partial_instllment->inst_no . '-a', 'due' => $partial_instllment->received, 'balance' => 0]);
                }

                $customer = Customer::where('id', $request->customer_id)->first();

                $property = CustomerProperty::where('id', $request->customer_property_id)->first();

                $received_amount = Receipt::where('customer_property_id', $request->customer_property_id)->sum('amount');

                $balance = $property->net_pay - $received_amount;



                //send sms
                // $message = "Hi " . $customer->name . ",Thank you for paying your installment of " . $request->amount . ". The remaining amount to be paid is Rs. " . $balance . " and then you can construct your own place at J7.!";

                $type =   EmailSmsType::where('name', 'like', 'Paid Installement')->first();
               
                if (!empty($type)) {
                    $project_name=    $property->inventory->multiProject? $property->inventory->multiProject->name:'None';
                    $detail =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
                    if (!empty($detail)) {
                        if ($detail->status == EmailSms::status_on) {
                            $msg =  $detail->content;
                            $message = __($msg, [
                                'name' =>  $customer->name,
                                'receivedamount' => $receipt->amount,
                                'unitnumber' => $property->inventory->unit_number,
                                'balance' => $balance,
                                'membership' =>  $property->membership_no

                            ]);
                          
                            if ($request->notify_email && $customer->email) {


                                // Mail::to($customer->email)->send(new InstallmentConfirmation($message));

                                $smtp = SmtpSetting::where('status', 1)->first();
                                $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                                    ->setUsername($smtp->smtp_username)
                                    ->setPassword($smtp->smtp_password);
                                $mailer = new \Swift_Mailer($transport);
                                $email = (new InstallmentConfirmation($message,$project_name))
                                    ->subject('Add Payment')
                                    ->from($smtp->from_email, $smtp->from_name)
                                    ->to($customer->email)
                                    ->view('emails.installment-confirmation');
                                $email_message = $email->render();
                                $swiftMessage = (new \Swift_Message())
                                    ->setSubject('Add Payment')
                                    ->setFrom($smtp->from_email, $smtp->from_name)
                                    ->setTo($customer->email)
                                    ->setBody($email_message, 'text/html');
                                $response = $mailer->send($swiftMessage);
                                $email_log =  new EmailLog;
                                $email_log->smpt_setting_id = $smtp->id;
                                $email_log->receiver_email = $customer->email;
                                $email_log->content = $message;
                                $email_log->title = 'Property Approved';
                                $email_log->mailable_class = 'new Membership';
                                $email_log->mail_view = 'emails.membership';

                                $email_log->project_name = $project_name;
                                if ($response) {

                                    $email_log->status = 1;
                                } else {
                                    $email_log->status = 1;
                                }
                                $email_log->save();
                            }
                        }
                    }

                    $detail2=   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
                    if (!empty($detail2)){
                        if ($detail2->status == EmailSms::status_on) {
                            $msg =  $detail2->content;
                            $message = __($msg, [
                                'name' =>  $customer->name,
                                'receivedamount' => $receipt->amount,
                                'unitnumber' => $property->inventory->unit_number,
                                'balance' => $balance,
                                'membership' =>  $property->membership_no

                            ]);
                    if ($request->notify_sms && $customer->mobile_number) {
                        $response=  SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                        $total_characters = strlen($message);
                        $sms_log= new SmsLog;
                        $sms_log->receiver_number = "92" . substr($customer->mobile_number, 1);
                        $sms_log->content =$message;
                        $sms_log->title='Paid Installement';
                        $sms_log->total_charcter =$total_characters;
                        if (strpos($response, 'Your Message is sent') !== false){
                          $sms_log->status = 1;
                        }
                        else{
                          $sms_log->status = 0;
                        }
                        $sms_log->project_name = $project_name;
                        $sms_log->response = $response;
                      $sms_log->save();
                  
                    }
                }
                }

                    // SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                }

                //send mail

            }


            // dd($request->all());

            if ($request->payment_method == Receipt::adjustment) {
                

                //  dd('inside',$request->all());
                if ($request->adjustment_type == Receipt::roll_back) {
                  
                    $cancelproperty = CancelProperty::where('id', $request->roll_back_properties)->first();
                    //  dd('yes');
                    Receipt::where('id', $receipt->id)->update(['cancel_property_id' => $cancelproperty->id]);
                    //   $receipt->cancel_property_id = $cancelproperty->id;
                    //                     $receipt->save();
             //        $total_received_amount = $cancelproperty->customerAdjustHistory->total_received_amount;
                
                    //  if($request->amount <=  $total_received_amount ){
                     //   dd('2',$request->adjustment_type, Receipt::roll_back, $total_received_amount);
                    //  dd( $total_received_amount);
                    //  CustomerAdjustment::create(['receipt_id' => $receipt->id, 'type' => $request->adjustment_type, 'description' => $request->adjustment_detail, 'merge_amount' => $request->amount]);
                    //  }
                    }

            }
            // $type =   EmailSmsType::where('name', 'like', 'Paid Installement')->first();
            // if (!empty($type)) {
            //     $detail =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
            //     if (!empty($detail)) {

            //         $property = CustomerProperty::where('id', $receipt->property->id)->first();

            //         $received_amount = Receipt::where('customer_property_id', $receipt->property->id)->sum('amount');

            //         $balance = $property->net_pay - $received_amount;
            //         $customer = Customer::where('id',$receipt->customer->id)->first();
            //         if ($detail->status == EmailSms::status_on) {
            //             $msg =  $detail->content;
            //             $message = __($msg, [
            //                 'name' =>  $receipt->customer->name,
            //                 'receivedamount' => $receipt->amount,
            //                 'unitnumber' => $receipt->property->inventory->unit_number,
            //                 'balance' => $balance,
            //                 'membership' =>  $receipt->property->membership_no

            //             ]);

            //             if ($request->notify_sms && $customer->mobile_number) {
            //                 SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
            //             }
            //             if ($request->notify_email && $customer->email) {


            //                 // Mail::to($customer->email)->send(new InstallmentConfirmation($message));

            //                 $smtp = SmtpSetting::where('status', 1)->first();
            //                 $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
            //                     ->setUsername($smtp->smtp_username)
            //                     ->setPassword($smtp->smtp_password);
            //                 $mailer = new \Swift_Mailer($transport);
            //                 $email = (new InstallmentConfirmation($message))
            //                     ->subject('Add Payment')
            //                     ->from($smtp->from_email, $smtp->from_name)
            //                     ->to($customer->email)
            //                     ->view('emails.installment-confirmation');
            //                 $email_message = $email->render();
            //                 $swiftMessage = (new \Swift_Message())
            //                     ->setSubject('Add Payment')
            //                     ->setFrom($smtp->from_email, $smtp->from_name)
            //                     ->setTo($customer->email)
            //                     ->setBody($email_message, 'text/html');
            //                 $response = $mailer->send($swiftMessage);
            //                 $email_log =  new EmailLog;
            //                 $email_log->smpt_setting_id = $smtp->id;
            //                 $email_log->receiver_email = $customer->email;
            //                 $email_log->content = $message;
            //                 $email_log->title = 'Property Approved';
            //                 $email_log->mailable_class = 'new Membership';
            //                 $email_log->mail_view = 'emails.membership';

            //                 if ($response) {

            //                     $email_log->status = 1;
            //                 } else {
            //                     $email_log->status = 1;
            //                 }
            //                 $email_log->save();
            //             }
            //         }
            //     }

            //     // SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
            // }

        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }

        // dd($receipt);
        DB::commit();
        return $receipt;
    }

    public function updateReceipt($request)
    {

        DB::beginTransaction();
        try {

            $receipt = Receipt::where('id', $request->id)->first();

            if (!$receipt->is_approved) {
                Receipt::where('id', $request->id)->update($request->except('roll_back_properties', 'token_amount', 'merging_properties', 'due', 'type', 'receipt_id', '_token', 'statement_id', 'permission'));
            } else {

                //delete previous record
                //  $cBank = CompanyBank::where('id',$receipt->company_account)->first();
                //  if($cBank) {

                //          CompanyBank::where('id',$receipt->company_account)->update(['amount'=>$cBank->amount - $receipt->amount ]);
                // //make transation
                //      CompanyBankTransaction::where('receipt_id', $receipt->id)->delete();

                //          }

                //dd($request);
                //update company account
                // if($request->payment_mode != Receipt::cash){

                //     $cBank = CompanyBank::where('id',$request->company_account)->first();
                //     if($cBank) {
                //         CompanyBank::where('id',$request->company_account)->update(['amount'=>$cBank->amount + $request->amount ]);

                //         //make transation
                //     CompanyBankTransaction::create(['receipt_id' => $request->id, 'company_account' => $request->company_account]);

                //     }

                // }

                // Receipt::where('id', $request->id)->update(Input::except('_token', 'statement_id'));
                // dd($request->all());
                Receipt::where('id', $request->id)->update($request->except(['_token', 'statement_id','permission']));

                //update customer record
                $customer = Customer::where('id', $request->customer_id)->first();
                Customer::where('id', $request->customer_id)->update(['total_paid_amount' => $customer->total_paid_amount - $receipt->amount + $request->amount]);

                if ($request->payment_head == Receipt::down_payment) {
                    CustomerProperty::where('id', $request->customer_property_id)->update(['invoice_number' => $request->receipt_no]);
                }

                $property = CustomerStatement::where('id', $request->statement_id)->first();
                //delete the previous record

                CustomerStatement::where('receipt_id', $request->id)->update([
                    'rcpt_no' => null,
                    'ref_no' => null, 'rcpt_date' => null, 'rcpt_amount' => 0, 'received' => 0,
                    'late_days' => 0, 'surcharge' => 0, 'receipt_id' => null, 'balance' => DB::raw('due')
                ]);


                // $amount = $request->amount;
                $rem_amount = $request->amount;
                $remaining_amount = 0;
                while ($rem_amount > 0) {

                    //check payment head is installment or other
                    if ((int)$receipt->payment_head !== Receipt::installment) {

                        $statement = CustomerStatement::where([
                            ['customer_property_id', $receipt->customer_property_id], ['payment_head', $receipt->payment_head], ['balance', '>', 0]
                        ])->first();

                        if ($statement) {

                            if (($statement->due - ($statement->received ? $statement->received : 0)) < $rem_amount) {
                                $amount = $statement->due - $statement->received;
                                $rem_amount -= $amount;
                            } else {
                                $amount = $rem_amount;
                                $rem_amount = 0;
                            }

                            if ($amount > 0) {

                                CustomerStatement::where('id', $statement->id)->update([
                                    'rcpt_no' => $receipt->receipt_no,
                                    'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $receipt->receipt_date,
                                    'rcpt_amount' => $amount, 'received' => $statement->received + $amount, 'receipt_id' => $receipt->id
                                ]);
                            }

                            //check surcharge apply or not
                            $property =  CustomerStatement::where('id', $statement->id)->first();

                            $pay = new Carbon($property->rcpt_date);
                            $due = new Carbon($property->due_date);
                            if ($pay > $due) {

                                $latedays = $pay->diffInDays($due);



                                $fine_per = SchedulePlan::first()->fine;

                                CustomerStatement::where('id', $statement->id)->update([
                                    'late_days' => $latedays,
                                    'surcharge' => $latedays * $fine_per
                                ]);
                            }

                            //update balance
                            CustomerStatement::where('id', $statement->id)->update(['balance' => $property->balance - $amount]);
                        } else {

                            if ($receipt->payment_head == Receipt::other) {
                                $receipt->payment_head = Receipt::installment;
                            } else {
                                $current_priority = PaymentHeadPriority::where('payment_head', $receipt->payment_head)->first()->priority;


                                $current_priority = $current_priority + 1;

                                $next_priority = PaymentHeadPriority::where('priority', $current_priority)->first();

                                if ($next_priority  == true) {
                                    $receipt->payment_head = $next_priority->payment_head;
                                } else {
                                    $receipt->payment_head = Receipt::installment;
                                }
                                // $receipt->payment_head++;
                            }
                        }
                    } else {

                        $remaining_amount = $rem_amount;

                        while ($remaining_amount > 0) {

                            $property =  CustomerStatement::where(
                                [
                                    ['customer_property_id', $request->customer_property_id], ['payment_head', $request->payment_head]
                                ]
                            )->where('received', '<', DB::raw('due'))->first();

                            if (($property->due - ($property->received ? $property->received : 0)) < $remaining_amount) {
                                $amount = $property->due - $property->received;
                                $remaining_amount -= $amount;
                            } else {
                                $amount = $remaining_amount;
                                $remaining_amount = 0;
                            }


                            CustomerStatement::where('id', $property->id)->update([
                                'rcpt_no' => $request->receipt_no,
                                'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $request->receipt_date,
                                'rcpt_amount' => $property->rcpt_amount + $amount, 'received' => $property->received + $amount, 'receipt_id' => $receipt->id
                            ]);

                            $property =  CustomerStatement::where('id', $property->id)->first();
                            // dd($property->rcpt_date);
                            $pay = new Carbon($property->rcpt_date);
                            $due = new Carbon($property->due_date);
                            if ($pay > $due) {

                                $latedays = $pay->diffInDays($due);

                                $fine_per = SchedulePlan::first()->fine;

                                CustomerStatement::where('id', $property->id)->update([
                                    'late_days' => $latedays,
                                    'surcharge' => $latedays * $fine_per
                                ]);
                            }

                            //update balance
                            CustomerStatement::where('id', $property->id)->update(['balance' => $property->balance - $amount]);
                        }
                        $rem_amount = $remaining_amount;
                    }
                }

                //if partiall payment then create new payment
                $partial_instllment = CustomerStatement::where([['customer_property_id', $receipt->customer_property_id], ['received', '>', '0'], ['balance', '!=', 0]])->first();


                if ($partial_instllment) {
                    CustomerStatement::create(['customer_id' => $partial_instllment->customer_id, 'customer_property_id' => $partial_instllment->customer_property_id, 'payment_head' => $partial_instllment->payment_head, 'inst_no' => $partial_instllment->inst_no . '-b', 'due_date' => $partial_instllment->due_date, 'due' => $partial_instllment->due - $partial_instllment->received, 'balance' => $partial_instllment->due - $partial_instllment->received, 'surcharge' => 0]);

                    CustomerStatement::where('id', $partial_instllment->id)->update(['inst_no' => $partial_instllment->inst_no . '-a', 'due' => $partial_instllment->received, 'balance' => 0]);
                }

                $customer = Customer::where('id', $request->customer_id)->first();

                $property = CustomerProperty::where('id', $request->customer_property_id)->first();

                $received_amount = Receipt::where('customer_property_id', $request->customer_property_id)->sum('amount');

                $balance = $property->net_pay - $received_amount;

                $type =   EmailSmsType::where('name', 'like', 'Paid Installement')->first();
                if (!empty($type)) {
                    $project_name=    $property->inventory->multiProject? $property->inventory->multiProject->name:'None';
                    $detail =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
                    if (!empty($detail)) {
                        if ($detail->status == EmailSms::status_on) {
                            $msg =  $detail->content;
                            $message = __($msg, [
                                'name' =>  $customer->name,
                                'receivedamount' => $receipt->amount,
                                'unitnumber' => $property->inventory->unit_number,
                                'balance' => $balance,
                                'membership' =>  $property->membership_no

                            ]);
                            if ($request->notify_sms && $customer->mobile_number) {
                                $response=   SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                          
                                $total_characters = strlen($message);
                                $sms_log= new SmsLog;
                                $sms_log->receiver_number = "92" . substr($customer->mobile_number, 1);
                                $sms_log->content =$message;
                                $sms_log->title='Paid Installement';
                                $sms_log->total_charcter =$total_characters;
                                if (strpos($response, 'Your Message is sent') !== false){
                                  $sms_log->status = 1;
                                }
                                else{
                                  $sms_log->status = 0;
                                }
                                $sms_log->project_name = $project_name;
                                $sms_log->response = $response;
                              $sms_log->save();
                            }
                        }
                    }

                   
                }


                // if ($request->notify_sms && $customer->mobile_number) {
                //     //send sms
                //     $message = "Hi " . $customer->name . ",Thank you for paying your installment of " . $request->amount . ". The remaining amount to be paid is Rs. " . $balance . " and then you can construct your own place at J7!";

                //     SmsController::sendSMS("0092" . substr($customer->mobile_number, 1), $message);







                // }


                // //check if paymenthead change or not
                // if((int)$receipt->payment_head == $request->payment_head) {

                //     //update the customer statement
                //     CustomerStatement::where('id',$request->statement_id)->update(['rcpt_no'=>$request->receipt_no,'ref_no'=>'RC'.$receipt->id,'rcpt_date'=>$request->receipt_date,
                //                'rcpt_amount'=>$request->amount,'received'=>$request->amount,'receipt_id'=>$request->id]);

                //     //check surcharge apply or not
                //     $property =  CustomerStatement::where('id',$request->statement_id)->first();

                //     $pay = new Carbon($property->rcpt_date);
                //     $due = new Carbon($property->due_date);
                //     if($pay > $due) {

                //         $latedays = $pay->diffInDays($due);

                //         CustomerStatement::where('id',$request->statement_id)->update(['late_days'=>$latedays,
                //                 'surcharge'=>$latedays * 100]);
                //     }

                //     //update the customer record
                //     CustomerStatement::where('id',$request->statement_id)->update(['balance'=>$property->due - $request->amount]);
                // }
                // else {
                //     $property = CustomerStatement::where('id',$request->statement_id)->first();
                //     //delete the previous record
                //     CustomerStatement::where('receipt_id', $request->statement_id)->update(['rcpt_no' => null,
                //         'ref_no' => null, 'rcpt_date' => null, 'rcpt_amount' => 0, 'received' => 0,
                //         'late_days' => 0, 'surcharge' => 0,'receipt_id'=>null,'balance'=>$property->due]);

                //     //check payment head is installment or other
                //     if ((int)$request->payment_head !== Receipt::installment) {

                //         CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                //             , ['payment_head', $request->payment_head]])->update(['rcpt_no' => $request->receipt_no,
                //             'ref_no' => 'RC'.$receipt->id, 'rcpt_date' => $request->receipt_date,
                //             'rcpt_amount' => $request->amount, 'received' => $request->amount,'receipt_id'=>$request->id]);

                //         //check surcharge apply or not
                //         $property = CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                //                     , ['payment_head', $request->payment_head]])->first();

                //         $pay = new Carbon($property->rcpt_date);
                //         $due = new Carbon($property->due_date);
                //         if ($pay > $due) {

                //             $latedays = $pay->diffInDays($due);

                //             CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                //                 , ['payment_head', $request->payment_head]])->update(['late_days' => $latedays,
                //                 'surcharge' => $latedays * 100]);
                //         }

                //         //update balance
                //         CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                //             , ['payment_head', $request->payment_head]])->update(['balance' => $property->due - $request->amount]);
                //     }
                //     else {

                //         $property = CustomerStatement::where([['customer_property_id', $request->customer_property_id]
                //                     , ['payment_head', $request->payment_head], ['received', null]])->first();


                //         CustomerStatement::where('id', $property->id)->update(['rcpt_no' => $request->receipt_no,
                //             'ref_no' => 'RC'.$receipt->id, 'rcpt_date' => $request->receipt_date,
                //             'rcpt_amount' => $request->amount, 'received' => $request->amount,'receipt_id'=>$request->id]);

                //         $property = CustomerStatement::where('id', $property->id)->first();
                //         // dd($property->rcpt_date);
                //         $pay = new Carbon($property->rcpt_date);
                //         $due = new Carbon($property->due_date);
                //         if ($pay > $due) {

                //             $latedays = $pay->diffInDays($due);

                //             CustomerStatement::where('id', $property->id)->update(['late_days' => $latedays,
                //                 'surcharge' => $latedays * 100]);
                //         }

                //         //update balance
                //         CustomerStatement::where('id', $property->id)->update(['balance' => $property->due - $request->amount]);
                //     }
                // }

                //        $receipt = Receipt::where('id',$request->id)->first();
                //
                //        $oldProperty =  CustomerStatement::where([['customer_property_id',$request->customer_property_id]
                //                    ,['payment_head',$receipt->payment_head],['received',$receipt->amount],['rcpt_date',$receipt->receipt_date]])->first();
                //
                //        //Delete Previous entries
                //        $customer = Customer::where('id',$receipt->customer_id)->first();
                //        Customer::where('id',$request->customer_id)->update(['total_paid_amount'=>$customer->total_paid_amount - $receipt->amount]);
                //
                //        if((int)$receipt->payment_head !== Receipt::installment) {
                //
                //            CustomerStatement::where([['customer_property_id',$receipt->customer_property_id]
                //                    ,['payment_head',$receipt->payment_head]])->update(['rcpt_no'=>null,
                //                            'ref_no'=>null,'rcpt_date'=>null,
                //                        'rcpt_amount'=>0,'received'=>0,'late_days'=>0,
                //                        'surcharge'=>0]);
                //            $property =  CustomerStatement::where([['customer_property_id',$receipt->customer_property_id]
                //                    ,['payment_head',$receipt->payment_head]])->first();
                //
                //            //update balance
                //            CustomerStatement::where([['customer_property_id',$receipt->customer_property_id]
                //                    ,['payment_head',$receipt->payment_head]])->update(['balance'=>$property->balance + $receipt->amount]);
                //        }
                //
                //        else {
                //
                //             $property =  CustomerStatement::where([['customer_property_id',$receipt->customer_property_id]
                //                    ,['payment_head',$receipt->payment_head],['received',$receipt->amount],['rcpt_date',$receipt->receipt_date]])->first();
                //
                //             CustomerStatement::where([['customer_property_id',$receipt->customer_property_id]
                //                    ,['payment_head',$receipt->payment_head],['recpt_date',$receipt->receipt_date]])->update(['rcpt_no'=>null,
                //                            'ref_no'=>null,'rcpt_date'=>null,
                //                        'rcpt_amount'=>0,'received'=>0,'late_days'=>0,
                //                        'surcharge'=>0]);
                //           // dd($property);
                //            $property =  CustomerStatement::where('id',$property->id)->first();
                //
                //            //update balance
                //            CustomerStatement::where('id',$property->id)->update(['balance'=>$property->balance + $receipt->amount]);
                //
                //        }
                //
                //
                //        //Add New Record
                //
                //        //
                //        Receipt::where('id',$request->id)->update(Input::except('_token'));
                //
                //        //update customer record
                //        $customer = Customer::where('id',$request->customer_id)->first();
                //        Customer::where('id',$request->customer_id)->update(['total_paid_amount'=>$customer->total_paid_amount + $request->amount]);
                //        //dd($request->payment_head);
                //        //update customer statement
                //        //check payment head is installment or other
                //        if((int)$request->payment_head !== Receipt::installment) {
                //
                //            CustomerStatement::where([['customer_property_id',$request->customer_property_id]
                //                    ,['payment_head',$request->payment_head]])->update(['rcpt_no'=>$request->receipt_no,
                //                            'ref_no'=>$request->reference_no,'rcpt_date'=>$request->receipt_date,
                //                        'rcpt_amount'=>$request->amount,'received'=>$request->amount]);
                //
                //            //check surcharge apply or not
                //            $property =  CustomerStatement::where([['customer_property_id',$request->customer_property_id]
                //                    ,['payment_head',$request->payment_head]])->first();
                //           // dd($property->rcpt_date);
                //            $pay = new Carbon($property->rcpt_date);
                //            $due = new Carbon($property->due_date);
                //            if($pay > $due) {
                //
                //                $latedays = $pay->diffInDays($due);
                //
                //                CustomerStatement::where([['customer_property_id',$request->customer_property_id]
                //                    ,['payment_head',$request->payment_head]])->update(['late_days'=>$latedays,
                //                        'surcharge'=>$latedays * 100]);
                //            }
                //
                //            //update balance
                //            CustomerStatement::where([['customer_property_id',$request->customer_property_id]
                //                    ,['payment_head',$request->payment_head]])->update(['balance'=>$property->balance - $request->amount]);
                //        }
                //
                //        else {
                //
                //            if($receipt->payment_head !== Receipt::installment){
                //                $property =  CustomerStatement::where([['customer_property_id',$request->customer_property_id]
                //                    ,['payment_head',$request->payment_head],['received',null]])->first();
                //            }
                //
                //            else{
                //            $property =  $oldProperty;
                //            }
                //
                //
                //            CustomerStatement::where('id',$property->id)->update(['rcpt_no'=>$request->receipt_no,
                //                            'ref_no'=>$request->reference_no,'rcpt_date'=>$request->receipt_date,
                //                        'rcpt_amount'=>$request->amount,'received'=>$request->amount]);
                //
                //            $property =  CustomerStatement::where('id',$property->id)->first();
                //            // dd($property->rcpt_date);
                //            $pay = new Carbon($property->rcpt_date);
                //            $due = new Carbon($property->due_date);
                //            if($pay > $due) {
                //
                //                $latedays = $pay->diffInDays($due);
                //
                //                CustomerStatement::where('id',$property->id)->update(['late_days'=>$latedays,
                //                        'surcharge'=>$latedays * 100]);
                //            }
                //
                //            //update balance
                //            CustomerStatement::where('id',$property->id)->update(['balance'=>$property->balance - $request->amount]);
                //
                //        }
                //
                //
                //
                //        return $receipt;

            }
        } catch (\Exception $e) {
            // dd($e);
            DB::rollback();
            return false;
        }
        DB::commit();

        return $receipt;
    }


    public function deleteReceipt($id)
    {

        $receipt = Receipt::where('id', $id)->first();

        //Delete Previous entries
        $customer = Customer::where('id', $receipt->customer_id)->first();
        Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $customer->total_paid_amount - $receipt->amount]);

        CustomerStatement::where('receipt_id', $id)->update(['balance' => DB::raw("`due`"), 'rcpt_no' => null, 'ref_no' => null, 'rcpt_date' => null, 'rcpt_amount' => 0, 'received' => 0, 'late_days' => 0, 'surcharge' => 0, 'receipt_id' => null, 'is_deleted' => false]);


        //  $properties =  CustomerStatement::where('receipt_id',$id)->get();

        //  foreach ($properties as $property) {



        //     // $property =  CustomerStatement::where('customer_property_id',$property->customer_property_id)->first();
        //     // if($property){
        //     // //update balance
        //     //     CustomerStatement::where('customer_property_id',$property->customer_property_id)->update(['balance'=>$property->balance + $receipt->amount]);
        //     // }

        // }


        Receipt::where('id', $id)->delete();

        return $receipt;
    }



    public function getInsNo($property_id, $receipt_id)
    {

        $data = '';

        $installments = CustomerStatement::where('customer_property_id', $property_id)->orderBy('due_date', 'desc')->get();
        $count = 1;

        foreach ($installments as $ins) {
            if ($ins->receipt_id == $receipt_id) {
                if ($ins->payment_head == Receipt::other) {
                    $data = 'other' . ', ' . $data;
                } else {
                    $data = $ins->inst_no . ', ' . $data;
                }
            }
        }

        return $data;

        // if($receipt_count == 1){
        //             $data = $ins_count;
        //         }
        //         elseif($receipt_count == 2) {
        //             $data = ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 3) {
        //             $data = ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 4) {
        //             $data = ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 5) {
        //             $data = ($ins_count - 4) . ',' . ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 6) {
        //             $data = ($ins_count - 5) . ',' . ($ins_count - 4) . ',' . ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 7) {
        //             $data = ($ins_count - 6) . ',' . ($ins_count - 5) . ',' . ($ins_count - 4) . ',' . ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 8) {
        //             $data = ($ins_count - 7) . ',' . ($ins_count - 6) . ',' . ($ins_count - 5) . ',' . ($ins_count - 4) . ',' . ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 9) {
        //             $data = ($ins_count - 8) . ',' . ($ins_count - 7) . ',' . ($ins_count - 6) . ',' . ($ins_count - 5) . ',' . ($ins_count - 4) . ',' . ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         elseif($receipt_count == 10) {
        //             $data = ($ins_count - 9) . ',' . ($ins_count - 8) . ',' . ($ins_count - 7) . ',' . ($ins_count - 6) . ',' . ($ins_count - 5) . ',' . ($ins_count - 4) . ',' . ($ins_count - 3) . ',' . ($ins_count - 2) . ',' . ($ins_count - 1) . ',' . $ins_count;
        //         }
        //         else {
        //             $data = $ins_count;
        //         }
        //         return $data;
    }

    public function updateTable($filters,$ids=null)
    {

        $query = Receipt::where('is_deleted', false)->where('is_approved', true)
        
->when($ids[0] !== 'all', function ($query) use ($ids) {
    $query->whereIn('multi_project_id', $ids);
                    })
        ->orderBy('receipt_date', 'asc');

        foreach ($filters as $key => $val) {
            if ($key == 'receipt_no')
                $query = $query->where('id', $val);
            elseif ($key == 'payment_head')
                $query = $query->where('payment_head', $val);
            elseif ($key == 'payment_mode' && $val != 'all')
                $query = $query->where('payment_method', $val);
            elseif ($key == 'unit')
                $query = $query->whereHas('property', function ($query) use ($val) {
                    $query->whereHas('inventory', function ($query) use ($val) {
                        $query->where('id', $val);
                    });
                });
            elseif ($key == 'customer')
                $query = $query->whereHas('customer', function ($query) use ($val) {
                    $query->where('id', $val);
                });
            elseif ($key == 'dealer')
                $query = $query->whereHas('property', function ($query) use ($val) {
                    $query->whereHas('dealer', function ($query) use ($val) {
                        $query->where('id', $val);
                    });
                });
        }
        $query->with('property');
        $data['receipts'] = $query->get();

        return $data;
    }

    public function approvedReceipt($id)
    {

        DB::beginTransaction();
        try {

            $receipt = Receipt::where('id', $id)->first();



            if (!$receipt->is_approved) {

                Receipt::where('id', $id)->update(['is_approved' => true]);



                if ($receipt->payment_head == Receipt::down_payment) {
                    CustomerProperty::where('id', $receipt->customer_property_id)->update(['invoice_number' => $receipt->receipt_no]);
                }
                if ($receipt->payment_mode != Receipt::cash && $receipt->payment_mode != Receipt::adjustment) {
                    $cBank = CompanyBank::where('id', $receipt->company_account)->first();
                    if ($cBank) {
                        // CompanyBank::where('id',$receipt->company_account)->update(['opening_balance'=>$cBank->opening_balance +$receipt->amount ]);

                        //make transation
                        CompanyBankTransaction::create(['receipt_id' => $receipt->id, 'company_account' => $receipt->company_account]);
                    }
                }
                if ($receipt->payment_method == Receipt::adjustment) {

                    //////////Update Purchase order Receipt//////////////////////////////////


                    if ($receipt->adjustment_type == Receipt::vendor) {
                        $purchase_order_recepit = PurchaseOrderReceipt::where('purchase_order_id', $receipt->vendor_purchase_order_id)->first();

                        $total_pay_amount = ($purchase_order_recepit->total_pay_amount + $receipt->amount);

                        $remaining_po_amount = ($purchase_order_recepit->total_amount - $total_pay_amount);

                        $dataArray = ['total_pay_amount' => $total_pay_amount, 'remaining_amount' => $remaining_po_amount];

                        if ($remaining_po_amount <= 0) {
                            $dataArray['is_book'] = 1;
                            $dataArray['status'] = 1;
                        }

                        if ($remaining_po_amount > 0) {

                            $dataArray['status'] = 2;
                        }

                        PurchaseOrderReceipt::where('purchase_order_id', $receipt->vendor_purchase_order_id)->update($dataArray);
                    }

                    if ($receipt->adjustment_type == Receipt::roll_back) {
                        CustomerAdjustment::create(['receipt_id' => $receipt->id, 'type' => $receipt->adjustment_type, 'description' => $receipt->adjustment_detail, 'merge_amount' => $receipt->amount]);
                    }
                    if ($receipt->adjustment_type == Receipt::rebate) {

                        $dealerTransaction = DealerTransaction::find($receipt->dealer_adjustment_unit_id);
                        //create new rebate
                        if ($dealerTransaction) {
                            $rebate = DealerPaidRebate::create(['dealer_id' => $dealerTransaction->dealer_id, 'property_id' => $dealerTransaction->product_id, 'amount' => $receipt->amount, 'date' => $receipt->receipt_date, 'description' => 'Installment paid aginst this rebate']);

                            $dealer = Dealer::where('id', $dealerTransaction->dealer_id)->first();

                            Dealer::where('id', $dealerTransaction->dealer_id)->update(['total_paid_amount' => $dealer->total_paid_amount + $receipt->amount]);
                        }
                    } else {
                        CustomerAdjustment::create(['receipt_id' => $receipt->id, 'type' => $receipt->adjustment_type, 'description' => $receipt->adjustment_detail, 'merge_amount' => $receipt->amount]);
                    }
                }
              
                //update customer record
                $customer = Customer::where('id', $receipt->customer_id)->first();
                Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $customer->total_paid_amount + $receipt->amount]);
                //update customer statement
                // $amount = $request->amount;
                $rem_amount = $receipt->amount; // receipt amount

                $remaining_amount = 0;
                $statement_payment_head = CustomerStatement::where([
                    ['customer_property_id', $receipt->customer_property_id]
                ])->distinct('payment_head')
                    ->pluck('payment_head');
 
                while ($rem_amount > 0) {

                    //check payment head is installment or other
                    if ((int)$receipt->payment_head !== Receipt::installment && count($statement_payment_head) > 1) {
                       
                        $statement = CustomerStatement::where([
                            ['customer_property_id', $receipt->customer_property_id], ['payment_head', $receipt->payment_head], ['balance', '>', 0]
                        ])->first();

                        if ($statement) {

                            if (($statement->due - ($statement->received ? $statement->received : 0)) < $rem_amount) {
                                $amount = $statement->due - $statement->received;
                                $rem_amount -= $amount;
                            } else {
                                $amount = $rem_amount;
                                $rem_amount = 0;
                            }

                            // dd($rem_amount,$amount);
                            if ($amount > 0) {

                                CustomerStatement::where('id', $statement->id)->update([
                                    'rcpt_no' => $receipt->receipt_no,
                                    'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $receipt->receipt_date,
                                    'rcpt_amount' => $amount, 'received' => $statement->received + $amount, 'receipt_id' => $receipt->id
                                ]);
                            }

                            //add the tax amount
                            // $tax_amount = $receipt->tax_amount;
                            $tax_amount = 0;
                            $received_amount_specific_payment_head = $statement->received + $amount;

                            if ($receipt->customer->is_filer == 1) {

                                $tax_amount =  (float)$received_amount_specific_payment_head * 0.01;
                            } else {
                                $tax_amount =  (float)$received_amount_specific_payment_head * 0.02;
                            }

                            // $tax_amount = $receipt->tax_amount;
                            if (empty($tax_amount)) {
                                $tax_amount = 0;
                            }

                            CustomerPropertyTax::create(['customer_id' => $receipt->customer_id, 'property_id' => $receipt->customer_property_id, 'tax' => $tax_amount, 'status' => 0, 'installment_id' => $statement->id, 'tax_pay_by' => $receipt->tax_paid_by, 'tax_payment_received' => $receipt->tax_payment_received]);

                            //check surcharge apply or not
                            $property =  CustomerStatement::where('id', $statement->id)->first();

                            $pay = new Carbon($property->rcpt_date);
                            $due = new Carbon($property->due_date);
                            if ($pay > $due) {

                                $latedays = $pay->diffInDays($due);
                                $fine_per = SchedulePlan::first()->fine;
                                CustomerStatement::where('id', $statement->id)->update([
                                    'late_days' => $latedays,
                                    'surcharge' => $latedays * $fine_per
                                ]);
                            }


                            //update balance
                            CustomerStatement::where('id', $statement->id)->update(['balance' => $property->balance - $amount]);
                        } else {



                            if ($receipt->payment_head == Receipt::other) {
                                $receipt->payment_head = Receipt::installment;
                            } else {


                                $current_priority = PaymentHeadPriority::where('payment_head', $receipt->payment_head)->first()->priority;


                                $current_priority = $current_priority + 1;

                                $next_priority = PaymentHeadPriority::where('priority', $current_priority)->first();

                                if ($next_priority  == true) {
                                    $receipt->payment_head = $next_priority->payment_head;
                                } else {
                                    $receipt->payment_head = Receipt::installment;
                                }
                            }

                            if ($receipt->payment_head == Receipt::installment) {

                                $payment_heads =  CustomerStatement::where([['customer_property_id', $receipt->customer_property_id], ['payment_head', '!=', Receipt::installment]])->where('received', 0)->where('due', '>', 0)->pluck('payment_head');

                                $next_priority = PaymentHeadPriority::whereIn('payment_head', $payment_heads)->orderBy('priority', 'ASC')->first();

                                if ($next_priority  == true) {
                                    $receipt->payment_head = $next_priority->payment_head;
                                } else {
                                    $receipt->payment_head = Receipt::installment;
                                }
                            }
                        }
                    } else {

                        $count =0;
                        $remaining_amount = $rem_amount;
                        while ($remaining_amount > 0) {
                            $count = $count +1;

                            $property =  CustomerStatement::where(
                                [
                                    ['customer_property_id', $receipt->customer_property_id],
                                     ['payment_head', $receipt->payment_head]
                                ]
                            )->where('received', '<', DB::raw('due'))
                            ->orderBy('due_date', 'asc')->first();

                            
                            if ($property == true) {
                            //    dd('true');

                                if (($property->due - ($property->received ? $property->received : 0)) < $remaining_amount) {
                                    $amount = $property->due - $property->received;
                                    $remaining_amount -= $amount;
                                } else {

                                    $amount = $remaining_amount;
                                    $remaining_amount = 0;
                                }

                                CustomerStatement::where('id', $property->id)->update([
                                    'rcpt_no' => $receipt->receipt_no,
                                    'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $receipt->receipt_date,
                                    'rcpt_amount' => $property->rcpt_amount + $amount, 'received' => $property->received + $amount, 'receipt_id' => $receipt->id
                                ]);

                                //add the tax amount

                                // $tax_amount = $receipt->tax_amount;


                                $tax_amount = 0;
                                $received_amount_specific_payment_head = $property->received + $amount;

                                if ($receipt->customer->is_filer == 1) {

                                    $tax_amount =  (float)$received_amount_specific_payment_head * 0.01;
                                } else {
                                    $tax_amount =  (float)$received_amount_specific_payment_head * 0.02;
                                }


                                CustomerPropertyTax::create(['customer_id' => $receipt->customer_id, 'property_id' => $receipt->customer_property_id, 'tax' => $tax_amount, 'status' => 0, 'installment_id' => $property->id, 'tax_pay_by' => $receipt->tax_paid_by, 'tax_payment_received' => $receipt->tax_payment_received]);

                                $property =  CustomerStatement::where('id', $property->id)
                                ->first();

                                $pay = new Carbon($property->rcpt_date);
                                $due = new Carbon($property->due_date);
                                if ($pay > $due) {

                                    $latedays = $pay->diffInDays($due);


                                    $fine_per = SchedulePlan::first()->fine;
                                    CustomerStatement::where('id', $property->id)->update([
                                        'late_days' => $latedays,
                                        'surcharge' => $latedays * $fine_per
                                    ]);
                                }

                                //update balance
                                CustomerStatement::where('id', $property->id)->update(['balance' => $property->balance - $amount]);
                               
                            } else {

                                
                                $current_priority = PaymentHeadPriority::where('payment_head', $receipt->payment_head)->first()->priority;
                                $current_priority = $current_priority + 1;
                                $next_priority = PaymentHeadPriority::where('priority', $current_priority)->first();
                                
                               $total_payment_head= PaymentHeadPriority::count();
                              
                                if ($next_priority  == true) {
                                    $receipt->payment_head = $next_priority->payment_head;
                                }
                                elseif($next_priority  == false && $current_priority < $total_payment_head){
                                    $current_priority = $current_priority + 1;
                                    $next_priority = PaymentHeadPriority::where('priority', $current_priority)->first();
                                    if ($next_priority  == true) {
                                        $receipt->payment_head = $next_priority->payment_head;
                                    }
                                }
                                else {
                                    $next_priority = PaymentHeadPriority::where('priority', 1)->first();
                                    $receipt->payment_head = $next_priority->payment_head;
                                    // $receipt->payment_head = Receipt::installment;
                                }
                                
                            }
 
                        }
 
                        $rem_amount = $remaining_amount;
                    }
                }
 
              

                //if partiall payment then create new payment
                $partial_instllment = CustomerStatement::where([['customer_property_id', $receipt->customer_property_id], ['received', '>', '0'], ['balance', '!=', 0]])->first();
                if ($partial_instllment) {
                    CustomerStatement::create(['customer_id' => $partial_instllment->customer_id, 'customer_property_id' => $partial_instllment->customer_property_id, 'payment_head' => $partial_instllment->payment_head, 'inst_no' => $partial_instllment->inst_no . '-b', 'due_date' => $partial_instllment->due_date, 'due' => $partial_instllment->due - $partial_instllment->received, 'balance' => $partial_instllment->due - $partial_instllment->received, 'surcharge' => 0]);

                    CustomerStatement::where('id', $partial_instllment->id)->update(['inst_no' => $partial_instllment->inst_no . '-a', 'due' => $partial_instllment->received, 'balance' => 0]);
                }

                $customer = Customer::where('id', $receipt->customer_id)->first();

                $property = CustomerProperty::where('id', $receipt->customer_property_id)->first();

                $received_amount = Receipt::where('customer_property_id', $receipt->customer_property_id)->sum('amount');

                $balance = $property->net_pay - $received_amount;



                $type =   EmailSmsType::where('name', 'like', 'Approve Installement Receipt')->first();
              
                if (!empty($type)) {
                    $project_name=    $property->inventory->multiProject? $property->inventory->multiProject->name:'None';

                    $detail =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
                    if (!empty($detail)) {
                        if ($detail->status == EmailSms::status_on) {
                            $msg =  $detail->content;
                            $message = __($msg, [
                                'name' =>  $customer->name,
                                'receivedamount' => $receipt->amount,
                                'unitnumber' => $property->inventory->unit_number,
                                'balance' => $balance,
                                'membership' =>  $property->membership_no

                            ]);
                           
                            if ($customer->email && $receipt->notify_email == 1) {

                           
                                // Mail::to($customer->email)->send(new InstallmentConfirmation($message));

                                $smtp = SmtpSetting::where('status', 1)->first();
                                $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                                    ->setUsername($smtp->smtp_username)
                                    ->setPassword($smtp->smtp_password);
                                $mailer = new \Swift_Mailer($transport);
                                $email = (new ApproveInstallementReceiptMail($message,$project_name))
                                    ->subject('Approve Installement Receipt')
                                    ->from($smtp->from_email, $smtp->from_name)
                                    ->to($customer->email)
                                    ->view('emails.approveinstallementreceipt');
                                $email_message = $email->render();
                                $swiftMessage = (new \Swift_Message())
                                    ->setSubject('Approve Installement Receipt')
                                    ->setFrom($smtp->from_email, $smtp->from_name)
                                    ->setTo($customer->email)
                                    ->setBody($email_message, 'text/html');
                                $response = $mailer->send($swiftMessage);
                                $email_log =  new EmailLog;
                                $email_log->smpt_setting_id = $smtp->id;
                                $email_log->receiver_email = $customer->email;
                                $email_log->content = $message;
                                $email_log->title = 'Approve Installement Receipt';
                                $email_log->mailable_class = 'new ApproveInstallementReceiptMail';
                                $email_log->mail_view = 'emails.approveinstallementreceipt';

                                $email_log->project_name = $project_name;
                                if ($response) {

                                    $email_log->status = 1;
                                } else {
                                    $email_log->status = 1;
                                }
                                $email_log->save();
                            }
                        }
                    }
                    $detail2 =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
                    if (!empty($detail2)) {
                        if ($detail2->status == EmailSms::status_on) {
                            $msg =  $detail2->content;
                            $message = __($msg, [
                                'name' =>  $customer->name,
                                'receivedamount' => $receipt->amount,
                                'unitnumber' => $property->inventory->unit_number,
                                'balance' => $balance,
                                'membership' =>  $property->membership_no

                            ]);
                            if ($customer->mobile_number  && $receipt->notify_sms == 1) {
                                $response=  SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                          
                                $total_characters = strlen($message);
                                $sms_log= new SmsLog;
                                $sms_log->receiver_number = "92" . substr($customer->mobile_number, 1);
                                $sms_log->content =$message;
                                $sms_log->title='Approve Installement Receipt';
                                $sms_log->total_charcter =$total_characters;
                                if (strpos($response, 'Your Message is sent') !== false){
                                  $sms_log->status = 1;
                                }
                                else{
                                  $sms_log->status = 0;
                                }
                                $sms_log->project_name = $project_name;
                                $sms_log->response = $response;
                              $sms_log->save();
                            }
                        }
                    }
                    // SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                }


                // if ($customer->mobile_number) {
                //     //send sms
                //     $message = "Asalam o Alikum, Dear " . $customer->name . " Thank You for paying your installment of PKR " . $receipt->amount . " only. Remaining  amount is PKR " . $balance . " only.
                //      Sales Department
                //      The Amaar Lodges";
                //     // $message = "Hi ".$customer->name.",Thank you for paying your installment of ".$receipt->amount.". The remaining amount to be paid is Rs. ".$balance." and then you can construct your own place at J7.!";

                //     SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                // }

                // //send mail
                // if ($customer->email) {

                //     //  Mail::to($customer->email)->send(new InstallmentConfirmation($customer,$balance,$receipt));
                // }
            }
        } catch (\Exception $e) {
           
            DB::rollback();
            return false;
        }
        DB::commit();
        return $receipt;
    }

    public function approvedAllReceipt($ids)
    {
 
        DB::beginTransaction();
        try {

            $receipts = Receipt::where('is_approved', false)
            ->whereIn('multi_project_id', $ids)
            ->get();

            foreach ($receipts as $receipt) {

                Receipt::where('id', $receipt->id)->update(['cheaque_status' => Receipt::approve]);

                if (!$receipt->is_approved) {

                    Receipt::where('id', $receipt->id)->update(['is_approved' => true]);


                    if ($receipt->payment_head == Receipt::down_payment) {
                        CustomerProperty::where('id', $receipt->customer_property_id)->update(['invoice_number' => $receipt->receipt_no]);
                    }

                    if ($receipt->payment_mode != Receipt::cash && $receipt->payment_mode != Receipt::adjustment) {
                        $cBank = CompanyBank::where('id', $receipt->company_account)->first();
                        if ($cBank) {
                            // CompanyBank::where('id',$receipt->company_account)->update(['opening_balance'=>$cBank->opening_balance +$receipt->amount ]);

                            //make transation
                            CompanyBankTransaction::create(['receipt_id' => $receipt->id, 'company_account' => $receipt->company_account]);
                        }
                    }

                    if ($receipt->payment_method == Receipt::adjustment) {
                        if ($receipt->adjustment_type == Receipt::rebate) {

                            $dealerTransaction = DealerTransaction::find($receipt->dealer_adjustment_unit_id);
                            //create new rebate
                            if ($dealerTransaction) {
                                $rebate = DealerPaidRebate::create(['dealer_id' => $dealerTransaction->dealer_id, 'property_id' => $dealerTransaction->product_id, 'amount' => $receipt->amount, 'date' => $receipt->receipt_date, 'description' => 'Installment paid aginst this rebate']);

                                $dealer = Dealer::where('id', $dealerTransaction->dealer_id)->first();

                                Dealer::where('id', $dealerTransaction->dealer_id)->update(['total_paid_amount' => $dealer->total_paid_amount + $receipt->amount]);
                            }
                        } else {
                            CustomerAdjustment::create(['receipt_id' => $receipt->id, 'type' => $receipt->adjustment_type, 'description' => $receipt->adjustment_detail, 'merge_amount' => $receipt->amount]);
                        }
                    }

                    //update customer record
                    $customer = Customer::where('id', $receipt->customer_id)->first();
                    Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $customer->total_paid_amount + $receipt->amount]);
                    //dd($request->payment_head);
                    //update customer statement

                    // $amount = $request->amount;
                    $rem_amount = $receipt->amount;
                    $remaining_amount = 0;
                    $statement_payment_head = CustomerStatement::where([
                        ['customer_property_id', $receipt->customer_property_id]
                    ])->distinct('payment_head')
                        ->pluck('payment_head');

                    while ($rem_amount > 0) {

                        //check payment head is installment or other
                        if ((int)$receipt->payment_head !== Receipt::installment && count($statement_payment_head)) {

                            $statement = CustomerStatement::where([
                                ['customer_property_id', $receipt->customer_property_id], ['payment_head', $receipt->payment_head], ['balance', '>', 0]
                            ])->first();

                            if ($statement) {

                                if (($statement->due - ($statement->received ? $statement->received : 0)) < $rem_amount) {
                                    $amount = $statement->due - $statement->received;
                                    $rem_amount -= $amount;
                                } else {
                                    $amount = $rem_amount;
                                    $rem_amount = 0;
                                }

                                if ($amount > 0) {

                                    CustomerStatement::where('id', $statement->id)->update([
                                        'rcpt_no' => $receipt->receipt_no,
                                        'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $receipt->receipt_date,
                                        'rcpt_amount' => $amount, 'received' => $statement->received + $amount, 'receipt_id' => $receipt->id
                                    ]);
                                }

                                //add the tax amount
                                $tax_amount = $receipt->tax_amount;
                                if (empty($tax_amount)) {
                                    $tax_amount = 0;
                                }

                                CustomerPropertyTax::create(['customer_id' => $receipt->customer_id, 'property_id' => $receipt->customer_property_id, 'tax' => $tax_amount, 'status' => 0, 'installment_id' => $statement->id, 'tax_pay_by' => $receipt->tax_paid_by, 'tax_payment_received' => $receipt->tax_payment_received]);

                                //check surcharge apply or not
                                $property =  CustomerStatement::where('id', $statement->id)->first();

                                $pay = new Carbon($property->rcpt_date);
                                $due = new Carbon($property->due_date);
                                if ($pay > $due) {

                                    $latedays = $pay->diffInDays($due);
                                    $fine_per = SchedulePlan::first()->fine;
                                    CustomerStatement::where('id', $statement->id)->update([
                                        'late_days' => $latedays,
                                        'surcharge' => $latedays * $fine_per
                                    ]);
                                }

                                //update balance
                                CustomerStatement::where('id', $statement->id)->update(['balance' => $property->balance - $amount]);
                            } else {

                                $current_priority = PaymentHeadPriority::where('payment_head', $receipt->payment_head)->first()->priority;


                                $current_priority = $current_priority + 1;

                                $next_priority = PaymentHeadPriority::where('priority', $current_priority)->first();

                                if ($next_priority  == true) {
                                    $receipt->payment_head = $next_priority->payment_head;
                                } else {
                                    $receipt->payment_head = Receipt::installment;
                                }
                            }
                        } else {

                            $remaining_amount = $rem_amount;

                            while ($remaining_amount > 0) {

                                $property =  CustomerStatement::where(
                                    [
                                        ['customer_property_id', $receipt->customer_property_id], ['payment_head', $receipt->payment_head]
                                    ]
                                )->where('received', '<', DB::raw('due'))->orderBy('due_date', 'asc')->first();

                                if (($property->due - ($property->received ? $property->received : 0)) < $remaining_amount) {
                                    $amount = $property->due - $property->received;
                                    $remaining_amount -= $amount;
                                } else {
                                    $amount = $remaining_amount;
                                    $remaining_amount = 0;
                                }


                                CustomerStatement::where('id', $property->id)->update([
                                    'rcpt_no' => $receipt->receipt_no,
                                    'ref_no' => 'RC' . $receipt->id, 'rcpt_date' => $receipt->receipt_date,
                                    'rcpt_amount' => $property->rcpt_amount + $amount, 'received' => $property->received + $amount, 'receipt_id' => $receipt->id
                                ]);

                                //add the tax amount
                                $tax_amount = $receipt->tax_amount;
                                CustomerPropertyTax::create(['customer_id' => $receipt->customer_id, 'property_id' => $receipt->customer_property_id, 'tax' => $tax_amount, 'status' => 0, 'installment_id' => $property->id, 'tax_pay_by' => $receipt->tax_paid_by, 'tax_payment_received' => $receipt->tax_payment_received]);

                                $property =  CustomerStatement::where('id', $property->id)->first();
                                // dd($property->rcpt_date);
                                $pay = new Carbon($property->rcpt_date);
                                $due = new Carbon($property->due_date);
                                if ($pay > $due) {

                                    $latedays = $pay->diffInDays($due);

                                    $fine_per = SchedulePlan::first()->fine;
                                    CustomerStatement::where('id', $property->id)->update([
                                        'late_days' => $latedays,
                                        'surcharge' => $latedays * $fine_per
                                    ]);
                                }

                                //update balance
                                CustomerStatement::where('id', $property->id)->update(['balance' => $property->balance - $amount]);
                            }
                            $rem_amount = $remaining_amount;
                        }
                    }

                    //if partiall payment then create new payment
                    $partial_instllment = CustomerStatement::where([['customer_property_id', $receipt->customer_property_id], ['received', '>', '0'], ['balance', '!=', 0]])->first();


                    if ($partial_instllment) {
                        CustomerStatement::create(['customer_id' => $partial_instllment->customer_id, 'customer_property_id' => $partial_instllment->customer_property_id, 'payment_head' => $partial_instllment->payment_head, 'inst_no' => $partial_instllment->inst_no . '-b', 'due_date' => $partial_instllment->due_date, 'due' => $partial_instllment->due - $partial_instllment->received, 'balance' => $partial_instllment->due - $partial_instllment->received, 'surcharge' => 0]);

                        CustomerStatement::where('id', $partial_instllment->id)->update(['inst_no' => $partial_instllment->inst_no . '-a', 'due' => $partial_instllment->received, 'balance' => 0]);
                    }

                    $customer = Customer::where('id', $receipt->customer_id)->first();

                    $property = CustomerProperty::where('id', $receipt->customer_property_id)->first();

                    $received_amount = Receipt::where('customer_property_id', $receipt->customer_property_id)->sum('amount');

                    $balance = $property->net_pay - $received_amount;




                    $type =   EmailSmsType::where('name', 'like', 'Approve Installement Receipt')->first();
                    $project_name=    $property->inventory->multiProject? $property->inventory->multiProject->name:'None';
                    if (!empty($type)) {
                        $detail =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
                        if (!empty($detail)) {
                            if ($detail->status == EmailSms::status_on) {
                                $msg =  $detail->content;
                                $message = __($msg, [
                                    'name' =>  $customer->name,
                                    'receivedamount' => $receipt->amount,
                                    'unitnumber' => $property->inventory->unit_number,
                                    'balance' => $balance,
                                    'membership' =>  $property->membership_no

                                ]);


                                if ($customer->email && $receipt->notify_email == 1) {

                                   
                                    // Mail::to($customer->email)->send(new InstallmentConfirmation($message));

                                    $smtp = SmtpSetting::where('status', 1)->first();
                                    $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                                        ->setUsername($smtp->smtp_username)
                                        ->setPassword($smtp->smtp_password);
                                    $mailer = new \Swift_Mailer($transport);
                                    $email = (new ApproveInstallementReceiptMail($message,$project_name))
                                        ->subject('Approve Installement Receipt')
                                        ->from($smtp->from_email, $smtp->from_name)
                                        ->to($customer->email)
                                        ->view('emails.approveinstallementreceipt');
                                    $email_message = $email->render();
                                    $swiftMessage = (new \Swift_Message())
                                        ->setSubject('Approve Installement Receipt')
                                        ->setFrom($smtp->from_email, $smtp->from_name)
                                        ->setTo($customer->email)
                                        ->setBody($email_message, 'text/html');
                                    $response = $mailer->send($swiftMessage);
                                    $email_log =  new EmailLog;
                                    $email_log->smpt_setting_id = $smtp->id;
                                    $email_log->receiver_email = $customer->email;
                                    $email_log->content = $message;
                                    $email_log->title = 'Approve Installement Receipt';
                                    $email_log->mailable_class = 'new ApproveInstallementReceiptMail';
                                    $email_log->mail_view = 'emails.approveinstallementreceipt';
                                    $email_log->project_name = $project_name;
                                    if ($response) {

                                        $email_log->status = 1;
                                    } else {
                                        $email_log->status = 1;
                                    }
                                    $email_log->save();
                                }
                            }
                        }
                        $detail2 =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
                        if (!empty($detail2)) {
                            if ($detail2->status == EmailSms::status_on) {
                                $msg =  $detail2->content;
                                $message = __($msg, [
                                    'name' =>  $customer->name,
                                    'receivedamount' => $receipt->amount,
                                    'unitnumber' => $property->inventory->unit_number,
                                    'balance' => $balance,
                                    'membership' =>  $property->membership_no

                                ]);

                                if ($customer->mobile_number && $receipt->notify_sms == 1) {
                                    $response=     SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                                    $total_characters = strlen($message);
                                    $sms_log= new SmsLog;
                                    $sms_log->receiver_number = "92" . substr($customer->mobile_number, 1);
                                    $sms_log->content =$message;
                                    $sms_log->title='Approve Installement Receipt';
                                    $sms_log->total_charcter =$total_characters;
                                    if (strpos($response, 'Your Message is sent') !== false){
                                      $sms_log->status = 1;
                                    }
                                    else{
                                      $sms_log->status = 0;
                                    }
                                    $sms_log->project_name = $project_name;
                                    $sms_log->response = $response;
                                  $sms_log->save();
                               
                                }
                            }
                        }
                    }
                    //         if ($customer->mobile_number) {
                    //             //send sms
                    //             $message = "Asalam o Alikum, Dear " . $customer->name . " Thank You for paying your installment of PKR " . $receipt->amount . " only. Remaining  amount is PKR " . $balance . " only.
                    // Sales Department
                    //   " . env('APP_NAME') . " ";
                    //             // $message = "Hi ".$customer->name.",Thank you for paying your installment of ".$receipt->amount.". The remaining amount to be paid is Rs. ".$balance." and then you can construct your own place at J7.!";

                    //             SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                    //         }

                    //         //send mail
                    //         if ($customer->email) {

                    //             //  Mail::to($customer->email)->send(new InstallmentConfirmation($customer,$balance,$receipt));
                    //         }
                }
            }
        } catch (\Exception $e) {
            //dd($e);
            DB::rollback();
            return false;
        }
        DB::commit();
        
        return $receipts;
    }
}
